
package me.snowdrop.istio.mixer.adapter.zipkin;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "sampleProbability",
    "url"
})
@IstioKind(name = "zipkin", plural = "zipkins")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class ZipkinSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("sampleProbability")
    @JsonPropertyDescription("")
    private Double sampleProbability;
    /**
     * 
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("")
    private String url;
    private final static long serialVersionUID = -4253148452354532291L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ZipkinSpec() {
    }

    /**
     * 
     * @param sampleProbability
     * @param url
     */
    public ZipkinSpec(Double sampleProbability, String url) {
        super();
        this.sampleProbability = sampleProbability;
        this.url = url;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sampleProbability")
    public Double getSampleProbability() {
        return sampleProbability;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sampleProbability")
    public void setSampleProbability(Double sampleProbability) {
        this.sampleProbability = sampleProbability;
    }

    /**
     * 
     * 
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * 
     * 
     */
    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

}
