package me.snowdrop.istio.mixer.adapter.zipkin;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ZipkinSpecBuilder extends ZipkinSpecFluentImpl<ZipkinSpecBuilder> implements VisitableBuilder<ZipkinSpec,ZipkinSpecBuilder>{

    ZipkinSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ZipkinSpecBuilder(){
            this(true);
    }
    public ZipkinSpecBuilder(Boolean validationEnabled){
            this(new ZipkinSpec(), validationEnabled);
    }
    public ZipkinSpecBuilder(ZipkinSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ZipkinSpecBuilder(ZipkinSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ZipkinSpec(), validationEnabled);
    }
    public ZipkinSpecBuilder(ZipkinSpecFluent<?> fluent,ZipkinSpec instance){
            this(fluent, instance, true);
    }
    public ZipkinSpecBuilder(ZipkinSpecFluent<?> fluent,ZipkinSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSampleProbability(instance.getSampleProbability()); 
            fluent.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public ZipkinSpecBuilder(ZipkinSpec instance){
            this(instance,true);
    }
    public ZipkinSpecBuilder(ZipkinSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSampleProbability(instance.getSampleProbability()); 
            this.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public ZipkinSpec build(){
            ZipkinSpec buildable = new ZipkinSpec(fluent.getSampleProbability(),fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ZipkinSpecBuilder that = (ZipkinSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
