package me.snowdrop.istio.mixer.adapter.zipkin;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.lang.Double;

public class ZipkinSpecFluentImpl<A extends ZipkinSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ZipkinSpecFluent<A>{

    private Double sampleProbability;
    private String url;

    public ZipkinSpecFluentImpl(){
    }
    public ZipkinSpecFluentImpl(ZipkinSpec instance){
            this.withSampleProbability(instance.getSampleProbability()); 
            this.withUrl(instance.getUrl()); 
    }

    public Double getSampleProbability(){
            return this.sampleProbability;
    }

    public A withSampleProbability(Double sampleProbability){
            this.sampleProbability=sampleProbability; return (A) this;
    }

    public Boolean hasSampleProbability(){
            return this.sampleProbability != null;
    }

    public String getUrl(){
            return this.url;
    }

    public A withUrl(String url){
            this.url=url; return (A) this;
    }

    public Boolean hasUrl(){
            return this.url != null;
    }

    public A withNewUrl(String arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1){
            return (A)withUrl(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ZipkinSpecFluentImpl that = (ZipkinSpecFluentImpl) o;
            if (sampleProbability != null ? !sampleProbability.equals(that.sampleProbability) :that.sampleProbability != null) return false;
            if (url != null ? !url.equals(that.url) :that.url != null) return false;
            return true;
    }




}
