package me.snowdrop.istio.mixer.template.apikey;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface ApiKeyFluent<A extends ApiKeyFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ApiKeyFluent.MetadataNested<A> withNewMetadata();
    public ApiKeyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ApiKeyFluent.MetadataNested<A> editMetadata();
    public ApiKeyFluent.MetadataNested<A> editOrNewMetadata();
    public ApiKeyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ApiKeySpec getSpec();
    public ApiKeySpec buildSpec();
    public A withSpec(ApiKeySpec spec);
    public Boolean hasSpec();
    public ApiKeyFluent.SpecNested<A> withNewSpec();
    public ApiKeyFluent.SpecNested<A> withNewSpecLike(ApiKeySpec item);
    public ApiKeyFluent.SpecNested<A> editSpec();
    public ApiKeyFluent.SpecNested<A> editOrNewSpec();
    public ApiKeyFluent.SpecNested<A> editOrNewSpecLike(ApiKeySpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ApiKeyFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,ApiKeySpecFluent<ApiKeyFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
