package me.snowdrop.istio.mixer.template.apikey;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ApiKeyListFluent<A extends ApiKeyListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ApiKey item);
    public A setToItems(int index,ApiKey item);
    public A addToItems(ApiKey... items);
    public A addAllToItems(Collection<ApiKey> items);
    public A removeFromItems(ApiKey... items);
    public A removeAllFromItems(Collection<ApiKey> items);
    public A removeMatchingFromItems(Predicate<ApiKeyBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ApiKey> getItems();
    public List<ApiKey> buildItems();
    public ApiKey buildItem(int index);
    public ApiKey buildFirstItem();
    public ApiKey buildLastItem();
    public ApiKey buildMatchingItem(Predicate<ApiKeyBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ApiKeyBuilder> predicate);
    public A withItems(List<ApiKey> items);
    public A withItems(ApiKey... items);
    public Boolean hasItems();
    public ApiKeyListFluent.ItemsNested<A> addNewItem();
    public ApiKeyListFluent.ItemsNested<A> addNewItemLike(ApiKey item);
    public ApiKeyListFluent.ItemsNested<A> setNewItemLike(int index,ApiKey item);
    public ApiKeyListFluent.ItemsNested<A> editItem(int index);
    public ApiKeyListFluent.ItemsNested<A> editFirstItem();
    public ApiKeyListFluent.ItemsNested<A> editLastItem();
    public ApiKeyListFluent.ItemsNested<A> editMatchingItem(Predicate<ApiKeyBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ApiKeyFluent<ApiKeyListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
