package me.snowdrop.istio.mixer.template.apikey;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.TimeStampBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import io.fabric8.kubernetes.api.builder.Fluent;
import me.snowdrop.istio.api.TimeStamp;
import java.lang.Integer;
import java.lang.StringBuffer;
import me.snowdrop.istio.api.TimeStampFluent;
import java.lang.Long;

public interface ApiKeySpecFluent<A extends ApiKeySpecFluent<A>> extends Fluent<A>{


    public String getApi();
    public A withApi(String api);
    public Boolean hasApi();
    public A withNewApi(String arg1);
    public A withNewApi(StringBuilder arg1);
    public A withNewApi(StringBuffer arg1);
    public String getApiKey();
    public A withApiKey(String apiKey);
    public Boolean hasApiKey();
    public A withNewApiKey(String arg1);
    public A withNewApiKey(StringBuilder arg1);
    public A withNewApiKey(StringBuffer arg1);
    public String getApiOperation();
    public A withApiOperation(String apiOperation);
    public Boolean hasApiOperation();
    public A withNewApiOperation(String arg1);
    public A withNewApiOperation(StringBuilder arg1);
    public A withNewApiOperation(StringBuffer arg1);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTimestamp instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getTimestamp();
    public TimeStamp buildTimestamp();
    public A withTimestamp(TimeStamp timestamp);
    public Boolean hasTimestamp();
    public A withNewTimestamp(Integer nanos,Long seconds);
    public ApiKeySpecFluent.TimestampNested<A> withNewTimestamp();
    public ApiKeySpecFluent.TimestampNested<A> withNewTimestampLike(TimeStamp item);
    public ApiKeySpecFluent.TimestampNested<A> editTimestamp();
    public ApiKeySpecFluent.TimestampNested<A> editOrNewTimestamp();
    public ApiKeySpecFluent.TimestampNested<A> editOrNewTimestampLike(TimeStamp item);

    public interface TimestampNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeStampFluent<ApiKeySpecFluent.TimestampNested<N>>{

        
    public N and();    public N endTimestamp();
}


}
