package me.snowdrop.istio.mixer.template.authorization;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import me.snowdrop.istio.api.cexl.TypedValue;

public class ActionFluentImpl<A extends me.snowdrop.istio.mixer.template.authorization.ActionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.mixer.template.authorization.ActionFluent<A>{

    private String method;
    private String namespace;
    private String path;
    private Map<String,TypedValue> properties;
    private String service;

    public ActionFluentImpl(){
    }
    public ActionFluentImpl(me.snowdrop.istio.mixer.template.authorization.Action instance){
            this.withMethod(instance.getMethod()); 
            this.withNamespace(instance.getNamespace()); 
            this.withPath(instance.getPath()); 
            this.withProperties(instance.getProperties()); 
            this.withService(instance.getService()); 
    }

    public String getMethod(){
            return this.method;
    }

    public A withMethod(String method){
            this.method=method; return (A) this;
    }

    public Boolean hasMethod(){
            return this.method != null;
    }

    public A withNewMethod(String arg1){
            return (A)withMethod(new String(arg1));
    }

    public A withNewMethod(StringBuilder arg1){
            return (A)withMethod(new String(arg1));
    }

    public A withNewMethod(StringBuffer arg1){
            return (A)withMethod(new String(arg1));
    }

    public String getNamespace(){
            return this.namespace;
    }

    public A withNamespace(String namespace){
            this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace(){
            return this.namespace != null;
    }

    public A withNewNamespace(String arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1){
            return (A)withNamespace(new String(arg1));
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public Boolean hasPath(){
            return this.path != null;
    }

    public A withNewPath(String arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1){
            return (A)withPath(new String(arg1));
    }

    public A addToProperties(String key,TypedValue value){
            if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap<String,TypedValue>(); }
            if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
    }

    public A addToProperties(Map<String,TypedValue> map){
            if(this.properties == null && map != null) { this.properties = new LinkedHashMap<String,TypedValue>(); }
            if(map != null) { this.properties.putAll(map);} return (A)this;
    }

    public A removeFromProperties(String key){
            if(this.properties == null) { return (A) this; }
            if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
    }

    public A removeFromProperties(Map<String,TypedValue> map){
            if(this.properties == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
    }

    public Map<String,TypedValue> getProperties(){
            return this.properties;
    }

    public A withProperties(Map<String,TypedValue> properties){
            if (properties == null) { this.properties =  null;} else {this.properties = new LinkedHashMap<String,TypedValue>(properties);} return (A) this;
    }

    public Boolean hasProperties(){
            return this.properties != null;
    }

    public String getService(){
            return this.service;
    }

    public A withService(String service){
            this.service=service; return (A) this;
    }

    public Boolean hasService(){
            return this.service != null;
    }

    public A withNewService(String arg1){
            return (A)withService(new String(arg1));
    }

    public A withNewService(StringBuilder arg1){
            return (A)withService(new String(arg1));
    }

    public A withNewService(StringBuffer arg1){
            return (A)withService(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ActionFluentImpl that = (ActionFluentImpl) o;
            if (method != null ? !method.equals(that.method) :that.method != null) return false;
            if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
            if (service != null ? !service.equals(that.service) :that.service != null) return false;
            return true;
    }




}
