package me.snowdrop.istio.mixer.template.authorization;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface AuthorizationFluent<A extends AuthorizationFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public AuthorizationFluent.MetadataNested<A> withNewMetadata();
    public AuthorizationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public AuthorizationFluent.MetadataNested<A> editMetadata();
    public AuthorizationFluent.MetadataNested<A> editOrNewMetadata();
    public AuthorizationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public AuthorizationSpec getSpec();
    public AuthorizationSpec buildSpec();
    public A withSpec(AuthorizationSpec spec);
    public Boolean hasSpec();
    public AuthorizationFluent.SpecNested<A> withNewSpec();
    public AuthorizationFluent.SpecNested<A> withNewSpecLike(AuthorizationSpec item);
    public AuthorizationFluent.SpecNested<A> editSpec();
    public AuthorizationFluent.SpecNested<A> editOrNewSpec();
    public AuthorizationFluent.SpecNested<A> editOrNewSpecLike(AuthorizationSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<AuthorizationFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,AuthorizationSpecFluent<AuthorizationFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
