package me.snowdrop.istio.mixer.template.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface AuthorizationListFluent<A extends AuthorizationListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Authorization item);
    public A setToItems(int index,Authorization item);
    public A addToItems(Authorization... items);
    public A addAllToItems(Collection<Authorization> items);
    public A removeFromItems(Authorization... items);
    public A removeAllFromItems(Collection<Authorization> items);
    public A removeMatchingFromItems(Predicate<AuthorizationBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Authorization> getItems();
    public List<Authorization> buildItems();
    public Authorization buildItem(int index);
    public Authorization buildFirstItem();
    public Authorization buildLastItem();
    public Authorization buildMatchingItem(Predicate<AuthorizationBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<AuthorizationBuilder> predicate);
    public A withItems(List<Authorization> items);
    public A withItems(Authorization... items);
    public Boolean hasItems();
    public AuthorizationListFluent.ItemsNested<A> addNewItem();
    public AuthorizationListFluent.ItemsNested<A> addNewItemLike(Authorization item);
    public AuthorizationListFluent.ItemsNested<A> setNewItemLike(int index,Authorization item);
    public AuthorizationListFluent.ItemsNested<A> editItem(int index);
    public AuthorizationListFluent.ItemsNested<A> editFirstItem();
    public AuthorizationListFluent.ItemsNested<A> editLastItem();
    public AuthorizationListFluent.ItemsNested<A> editMatchingItem(Predicate<AuthorizationBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,AuthorizationFluent<AuthorizationListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
