package me.snowdrop.istio.mixer.template.edge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EdgeBuilder extends EdgeFluentImpl<EdgeBuilder> implements VisitableBuilder<Edge,EdgeBuilder>{

    EdgeFluent<?> fluent;
    Boolean validationEnabled;

    public EdgeBuilder(){
            this(true);
    }
    public EdgeBuilder(Boolean validationEnabled){
            this(new Edge(), validationEnabled);
    }
    public EdgeBuilder(EdgeFluent<?> fluent){
            this(fluent, true);
    }
    public EdgeBuilder(EdgeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Edge(), validationEnabled);
    }
    public EdgeBuilder(EdgeFluent<?> fluent,Edge instance){
            this(fluent, instance, true);
    }
    public EdgeBuilder(EdgeFluent<?> fluent,Edge instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public EdgeBuilder(Edge instance){
            this(instance,true);
    }
    public EdgeBuilder(Edge instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public Edge build(){
            Edge buildable = new Edge(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EdgeBuilder that = (EdgeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
