
package me.snowdrop.istio.mixer.template.edge;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.TimeStamp;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "apiProtocol",
    "contextProtocol",
    "destinationOwner",
    "destinationServiceName",
    "destinationServiceNamespace",
    "destinationUid",
    "destinationWorkloadName",
    "destinationWorkloadNamespace",
    "name",
    "sourceOwner",
    "sourceUid",
    "sourceWorkloadName",
    "sourceWorkloadNamespace",
    "timestamp"
})
@IstioKind(name = "edge", plural = "edges")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class EdgeSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("apiProtocol")
    @JsonPropertyDescription("")
    private String apiProtocol;
    /**
     * 
     * 
     */
    @JsonProperty("contextProtocol")
    @JsonPropertyDescription("")
    private String contextProtocol;
    /**
     * 
     * 
     */
    @JsonProperty("destinationOwner")
    @JsonPropertyDescription("")
    private String destinationOwner;
    /**
     * 
     * 
     */
    @JsonProperty("destinationServiceName")
    @JsonPropertyDescription("")
    private String destinationServiceName;
    /**
     * 
     * 
     */
    @JsonProperty("destinationServiceNamespace")
    @JsonPropertyDescription("")
    private String destinationServiceNamespace;
    /**
     * 
     * 
     */
    @JsonProperty("destinationUid")
    @JsonPropertyDescription("")
    private String destinationUid;
    /**
     * 
     * 
     */
    @JsonProperty("destinationWorkloadName")
    @JsonPropertyDescription("")
    private String destinationWorkloadName;
    /**
     * 
     * 
     */
    @JsonProperty("destinationWorkloadNamespace")
    @JsonPropertyDescription("")
    private String destinationWorkloadNamespace;
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     * 
     */
    @JsonProperty("sourceOwner")
    @JsonPropertyDescription("")
    private String sourceOwner;
    /**
     * 
     * 
     */
    @JsonProperty("sourceUid")
    @JsonPropertyDescription("")
    private String sourceUid;
    /**
     * 
     * 
     */
    @JsonProperty("sourceWorkloadName")
    @JsonPropertyDescription("")
    private String sourceWorkloadName;
    /**
     * 
     * 
     */
    @JsonProperty("sourceWorkloadNamespace")
    @JsonPropertyDescription("")
    private String sourceWorkloadNamespace;
    /**
     * 
     * 
     */
    @JsonProperty("timestamp")
    @JsonPropertyDescription("")
    private TimeStamp timestamp;
    private final static long serialVersionUID = 4291845578002177931L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EdgeSpec() {
    }

    /**
     * 
     * @param sourceWorkloadName
     * @param sourceWorkloadNamespace
     * @param destinationServiceName
     * @param destinationUid
     * @param sourceOwner
     * @param apiProtocol
     * @param destinationWorkloadName
     * @param sourceUid
     * @param destinationWorkloadNamespace
     * @param contextProtocol
     * @param name
     * @param destinationOwner
     * @param destinationServiceNamespace
     * @param timestamp
     */
    public EdgeSpec(String apiProtocol, String contextProtocol, String destinationOwner, String destinationServiceName, String destinationServiceNamespace, String destinationUid, String destinationWorkloadName, String destinationWorkloadNamespace, String name, String sourceOwner, String sourceUid, String sourceWorkloadName, String sourceWorkloadNamespace, TimeStamp timestamp) {
        super();
        this.apiProtocol = apiProtocol;
        this.contextProtocol = contextProtocol;
        this.destinationOwner = destinationOwner;
        this.destinationServiceName = destinationServiceName;
        this.destinationServiceNamespace = destinationServiceNamespace;
        this.destinationUid = destinationUid;
        this.destinationWorkloadName = destinationWorkloadName;
        this.destinationWorkloadNamespace = destinationWorkloadNamespace;
        this.name = name;
        this.sourceOwner = sourceOwner;
        this.sourceUid = sourceUid;
        this.sourceWorkloadName = sourceWorkloadName;
        this.sourceWorkloadNamespace = sourceWorkloadNamespace;
        this.timestamp = timestamp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiProtocol")
    public String getApiProtocol() {
        return apiProtocol;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiProtocol")
    public void setApiProtocol(String apiProtocol) {
        this.apiProtocol = apiProtocol;
    }

    /**
     * 
     * 
     */
    @JsonProperty("contextProtocol")
    public String getContextProtocol() {
        return contextProtocol;
    }

    /**
     * 
     * 
     */
    @JsonProperty("contextProtocol")
    public void setContextProtocol(String contextProtocol) {
        this.contextProtocol = contextProtocol;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationOwner")
    public String getDestinationOwner() {
        return destinationOwner;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationOwner")
    public void setDestinationOwner(String destinationOwner) {
        this.destinationOwner = destinationOwner;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationServiceName")
    public String getDestinationServiceName() {
        return destinationServiceName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationServiceName")
    public void setDestinationServiceName(String destinationServiceName) {
        this.destinationServiceName = destinationServiceName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationServiceNamespace")
    public String getDestinationServiceNamespace() {
        return destinationServiceNamespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationServiceNamespace")
    public void setDestinationServiceNamespace(String destinationServiceNamespace) {
        this.destinationServiceNamespace = destinationServiceNamespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationUid")
    public String getDestinationUid() {
        return destinationUid;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationUid")
    public void setDestinationUid(String destinationUid) {
        this.destinationUid = destinationUid;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationWorkloadName")
    public String getDestinationWorkloadName() {
        return destinationWorkloadName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationWorkloadName")
    public void setDestinationWorkloadName(String destinationWorkloadName) {
        this.destinationWorkloadName = destinationWorkloadName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationWorkloadNamespace")
    public String getDestinationWorkloadNamespace() {
        return destinationWorkloadNamespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationWorkloadNamespace")
    public void setDestinationWorkloadNamespace(String destinationWorkloadNamespace) {
        this.destinationWorkloadNamespace = destinationWorkloadNamespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceOwner")
    public String getSourceOwner() {
        return sourceOwner;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceOwner")
    public void setSourceOwner(String sourceOwner) {
        this.sourceOwner = sourceOwner;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceUid")
    public String getSourceUid() {
        return sourceUid;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceUid")
    public void setSourceUid(String sourceUid) {
        this.sourceUid = sourceUid;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceWorkloadName")
    public String getSourceWorkloadName() {
        return sourceWorkloadName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceWorkloadName")
    public void setSourceWorkloadName(String sourceWorkloadName) {
        this.sourceWorkloadName = sourceWorkloadName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceWorkloadNamespace")
    public String getSourceWorkloadNamespace() {
        return sourceWorkloadNamespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceWorkloadNamespace")
    public void setSourceWorkloadNamespace(String sourceWorkloadNamespace) {
        this.sourceWorkloadNamespace = sourceWorkloadNamespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timestamp")
    public TimeStamp getTimestamp() {
        return timestamp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timestamp")
    public void setTimestamp(TimeStamp timestamp) {
        this.timestamp = timestamp;
    }

}
