package me.snowdrop.istio.mixer.template.edge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EdgeSpecBuilder extends EdgeSpecFluentImpl<EdgeSpecBuilder> implements VisitableBuilder<EdgeSpec,EdgeSpecBuilder>{

    EdgeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public EdgeSpecBuilder(){
            this(true);
    }
    public EdgeSpecBuilder(Boolean validationEnabled){
            this(new EdgeSpec(), validationEnabled);
    }
    public EdgeSpecBuilder(EdgeSpecFluent<?> fluent){
            this(fluent, true);
    }
    public EdgeSpecBuilder(EdgeSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EdgeSpec(), validationEnabled);
    }
    public EdgeSpecBuilder(EdgeSpecFluent<?> fluent,EdgeSpec instance){
            this(fluent, instance, true);
    }
    public EdgeSpecBuilder(EdgeSpecFluent<?> fluent,EdgeSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiProtocol(instance.getApiProtocol()); 
            fluent.withContextProtocol(instance.getContextProtocol()); 
            fluent.withDestinationOwner(instance.getDestinationOwner()); 
            fluent.withDestinationServiceName(instance.getDestinationServiceName()); 
            fluent.withDestinationServiceNamespace(instance.getDestinationServiceNamespace()); 
            fluent.withDestinationUid(instance.getDestinationUid()); 
            fluent.withDestinationWorkloadName(instance.getDestinationWorkloadName()); 
            fluent.withDestinationWorkloadNamespace(instance.getDestinationWorkloadNamespace()); 
            fluent.withName(instance.getName()); 
            fluent.withSourceOwner(instance.getSourceOwner()); 
            fluent.withSourceUid(instance.getSourceUid()); 
            fluent.withSourceWorkloadName(instance.getSourceWorkloadName()); 
            fluent.withSourceWorkloadNamespace(instance.getSourceWorkloadNamespace()); 
            fluent.withTimestamp(instance.getTimestamp()); 
            this.validationEnabled = validationEnabled; 
    }
    public EdgeSpecBuilder(EdgeSpec instance){
            this(instance,true);
    }
    public EdgeSpecBuilder(EdgeSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiProtocol(instance.getApiProtocol()); 
            this.withContextProtocol(instance.getContextProtocol()); 
            this.withDestinationOwner(instance.getDestinationOwner()); 
            this.withDestinationServiceName(instance.getDestinationServiceName()); 
            this.withDestinationServiceNamespace(instance.getDestinationServiceNamespace()); 
            this.withDestinationUid(instance.getDestinationUid()); 
            this.withDestinationWorkloadName(instance.getDestinationWorkloadName()); 
            this.withDestinationWorkloadNamespace(instance.getDestinationWorkloadNamespace()); 
            this.withName(instance.getName()); 
            this.withSourceOwner(instance.getSourceOwner()); 
            this.withSourceUid(instance.getSourceUid()); 
            this.withSourceWorkloadName(instance.getSourceWorkloadName()); 
            this.withSourceWorkloadNamespace(instance.getSourceWorkloadNamespace()); 
            this.withTimestamp(instance.getTimestamp()); 
            this.validationEnabled = validationEnabled; 
    }

    public EdgeSpec build(){
            EdgeSpec buildable = new EdgeSpec(fluent.getApiProtocol(),fluent.getContextProtocol(),fluent.getDestinationOwner(),fluent.getDestinationServiceName(),fluent.getDestinationServiceNamespace(),fluent.getDestinationUid(),fluent.getDestinationWorkloadName(),fluent.getDestinationWorkloadNamespace(),fluent.getName(),fluent.getSourceOwner(),fluent.getSourceUid(),fluent.getSourceWorkloadName(),fluent.getSourceWorkloadNamespace(),fluent.getTimestamp());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EdgeSpecBuilder that = (EdgeSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
