package me.snowdrop.istio.mixer.template.listentry;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ListEntryListBuilder extends ListEntryListFluentImpl<ListEntryListBuilder> implements VisitableBuilder<ListEntryList,ListEntryListBuilder>{

    ListEntryListFluent<?> fluent;
    Boolean validationEnabled;

    public ListEntryListBuilder(){
            this(true);
    }
    public ListEntryListBuilder(Boolean validationEnabled){
            this(new ListEntryList(), validationEnabled);
    }
    public ListEntryListBuilder(ListEntryListFluent<?> fluent){
            this(fluent, true);
    }
    public ListEntryListBuilder(ListEntryListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ListEntryList(), validationEnabled);
    }
    public ListEntryListBuilder(ListEntryListFluent<?> fluent,ListEntryList instance){
            this(fluent, instance, true);
    }
    public ListEntryListBuilder(ListEntryListFluent<?> fluent,ListEntryList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListEntryListBuilder(ListEntryList instance){
            this(instance,true);
    }
    public ListEntryListBuilder(ListEntryList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ListEntryList build(){
            ListEntryList buildable = new ListEntryList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ListEntryListBuilder that = (ListEntryListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
