package me.snowdrop.istio.mixer.template.listentry;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ListEntryListFluent<A extends ListEntryListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ListEntry item);
    public A setToItems(int index,ListEntry item);
    public A addToItems(ListEntry... items);
    public A addAllToItems(Collection<ListEntry> items);
    public A removeFromItems(ListEntry... items);
    public A removeAllFromItems(Collection<ListEntry> items);
    public A removeMatchingFromItems(Predicate<ListEntryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ListEntry> getItems();
    public List<ListEntry> buildItems();
    public ListEntry buildItem(int index);
    public ListEntry buildFirstItem();
    public ListEntry buildLastItem();
    public ListEntry buildMatchingItem(Predicate<ListEntryBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ListEntryBuilder> predicate);
    public A withItems(List<ListEntry> items);
    public A withItems(ListEntry... items);
    public Boolean hasItems();
    public ListEntryListFluent.ItemsNested<A> addNewItem();
    public ListEntryListFluent.ItemsNested<A> addNewItemLike(ListEntry item);
    public ListEntryListFluent.ItemsNested<A> setNewItemLike(int index,ListEntry item);
    public ListEntryListFluent.ItemsNested<A> editItem(int index);
    public ListEntryListFluent.ItemsNested<A> editFirstItem();
    public ListEntryListFluent.ItemsNested<A> editLastItem();
    public ListEntryListFluent.ItemsNested<A> editMatchingItem(Predicate<ListEntryBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ListEntryFluent<ListEntryListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
