package me.snowdrop.istio.mixer.template.logentry;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LogEntryListBuilder extends LogEntryListFluentImpl<LogEntryListBuilder> implements VisitableBuilder<LogEntryList,LogEntryListBuilder>{

    LogEntryListFluent<?> fluent;
    Boolean validationEnabled;

    public LogEntryListBuilder(){
            this(true);
    }
    public LogEntryListBuilder(Boolean validationEnabled){
            this(new LogEntryList(), validationEnabled);
    }
    public LogEntryListBuilder(LogEntryListFluent<?> fluent){
            this(fluent, true);
    }
    public LogEntryListBuilder(LogEntryListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LogEntryList(), validationEnabled);
    }
    public LogEntryListBuilder(LogEntryListFluent<?> fluent,LogEntryList instance){
            this(fluent, instance, true);
    }
    public LogEntryListBuilder(LogEntryListFluent<?> fluent,LogEntryList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public LogEntryListBuilder(LogEntryList instance){
            this(instance,true);
    }
    public LogEntryListBuilder(LogEntryList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public LogEntryList build(){
            LogEntryList buildable = new LogEntryList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LogEntryListBuilder that = (LogEntryListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
