package me.snowdrop.istio.mixer.template.logentry;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface LogEntryListFluent<A extends LogEntryListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,LogEntry item);
    public A setToItems(int index,LogEntry item);
    public A addToItems(LogEntry... items);
    public A addAllToItems(Collection<LogEntry> items);
    public A removeFromItems(LogEntry... items);
    public A removeAllFromItems(Collection<LogEntry> items);
    public A removeMatchingFromItems(Predicate<LogEntryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<LogEntry> getItems();
    public List<LogEntry> buildItems();
    public LogEntry buildItem(int index);
    public LogEntry buildFirstItem();
    public LogEntry buildLastItem();
    public LogEntry buildMatchingItem(Predicate<LogEntryBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<LogEntryBuilder> predicate);
    public A withItems(List<LogEntry> items);
    public A withItems(LogEntry... items);
    public Boolean hasItems();
    public LogEntryListFluent.ItemsNested<A> addNewItem();
    public LogEntryListFluent.ItemsNested<A> addNewItemLike(LogEntry item);
    public LogEntryListFluent.ItemsNested<A> setNewItemLike(int index,LogEntry item);
    public LogEntryListFluent.ItemsNested<A> editItem(int index);
    public LogEntryListFluent.ItemsNested<A> editFirstItem();
    public LogEntryListFluent.ItemsNested<A> editLastItem();
    public LogEntryListFluent.ItemsNested<A> editMatchingItem(Predicate<LogEntryBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,LogEntryFluent<LogEntryListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
