package me.snowdrop.istio.mixer.template.logentry;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LogEntrySpecBuilder extends LogEntrySpecFluentImpl<LogEntrySpecBuilder> implements VisitableBuilder<LogEntrySpec,LogEntrySpecBuilder>{

    LogEntrySpecFluent<?> fluent;
    Boolean validationEnabled;

    public LogEntrySpecBuilder(){
            this(true);
    }
    public LogEntrySpecBuilder(Boolean validationEnabled){
            this(new LogEntrySpec(), validationEnabled);
    }
    public LogEntrySpecBuilder(LogEntrySpecFluent<?> fluent){
            this(fluent, true);
    }
    public LogEntrySpecBuilder(LogEntrySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LogEntrySpec(), validationEnabled);
    }
    public LogEntrySpecBuilder(LogEntrySpecFluent<?> fluent,LogEntrySpec instance){
            this(fluent, instance, true);
    }
    public LogEntrySpecBuilder(LogEntrySpecFluent<?> fluent,LogEntrySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMonitoredResourceDimensions(instance.getMonitoredResourceDimensions()); 
            fluent.withMonitoredResourceType(instance.getMonitoredResourceType()); 
            fluent.withName(instance.getName()); 
            fluent.withSeverity(instance.getSeverity()); 
            fluent.withTimestamp(instance.getTimestamp()); 
            fluent.withVariables(instance.getVariables()); 
            this.validationEnabled = validationEnabled; 
    }
    public LogEntrySpecBuilder(LogEntrySpec instance){
            this(instance,true);
    }
    public LogEntrySpecBuilder(LogEntrySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMonitoredResourceDimensions(instance.getMonitoredResourceDimensions()); 
            this.withMonitoredResourceType(instance.getMonitoredResourceType()); 
            this.withName(instance.getName()); 
            this.withSeverity(instance.getSeverity()); 
            this.withTimestamp(instance.getTimestamp()); 
            this.withVariables(instance.getVariables()); 
            this.validationEnabled = validationEnabled; 
    }

    public LogEntrySpec build(){
            LogEntrySpec buildable = new LogEntrySpec(fluent.getMonitoredResourceDimensions(),fluent.getMonitoredResourceType(),fluent.getName(),fluent.getSeverity(),fluent.getTimestamp(),fluent.getVariables());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LogEntrySpecBuilder that = (LogEntrySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
