package me.snowdrop.istio.mixer.template.logentry;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.TimeStampBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.cexl.TypedValue;
import io.fabric8.kubernetes.api.builder.Fluent;
import me.snowdrop.istio.api.TimeStamp;
import java.lang.Integer;
import java.lang.StringBuffer;
import me.snowdrop.istio.api.TimeStampFluent;
import java.lang.Long;
import java.util.Map;

public interface LogEntrySpecFluent<A extends LogEntrySpecFluent<A>> extends Fluent<A>{


    public A addToMonitoredResourceDimensions(String key,TypedValue value);
    public A addToMonitoredResourceDimensions(Map<String,TypedValue> map);
    public A removeFromMonitoredResourceDimensions(String key);
    public A removeFromMonitoredResourceDimensions(Map<String,TypedValue> map);
    public Map<String,TypedValue> getMonitoredResourceDimensions();
    public A withMonitoredResourceDimensions(Map<String,TypedValue> monitoredResourceDimensions);
    public Boolean hasMonitoredResourceDimensions();
    public String getMonitoredResourceType();
    public A withMonitoredResourceType(String monitoredResourceType);
    public Boolean hasMonitoredResourceType();
    public A withNewMonitoredResourceType(String arg1);
    public A withNewMonitoredResourceType(StringBuilder arg1);
    public A withNewMonitoredResourceType(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getSeverity();
    public A withSeverity(String severity);
    public Boolean hasSeverity();
    public A withNewSeverity(String arg1);
    public A withNewSeverity(StringBuilder arg1);
    public A withNewSeverity(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTimestamp instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getTimestamp();
    public TimeStamp buildTimestamp();
    public A withTimestamp(TimeStamp timestamp);
    public Boolean hasTimestamp();
    public A withNewTimestamp(Integer nanos,Long seconds);
    public LogEntrySpecFluent.TimestampNested<A> withNewTimestamp();
    public LogEntrySpecFluent.TimestampNested<A> withNewTimestampLike(TimeStamp item);
    public LogEntrySpecFluent.TimestampNested<A> editTimestamp();
    public LogEntrySpecFluent.TimestampNested<A> editOrNewTimestamp();
    public LogEntrySpecFluent.TimestampNested<A> editOrNewTimestampLike(TimeStamp item);
    public A addToVariables(String key,TypedValue value);
    public A addToVariables(Map<String,TypedValue> map);
    public A removeFromVariables(String key);
    public A removeFromVariables(Map<String,TypedValue> map);
    public Map<String,TypedValue> getVariables();
    public A withVariables(Map<String,TypedValue> variables);
    public Boolean hasVariables();

    public interface TimestampNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeStampFluent<LogEntrySpecFluent.TimestampNested<N>>{

        
    public N and();    public N endTimestamp();
}


}
