package me.snowdrop.istio.mixer.template.metric;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface MetricFluent<A extends MetricFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public MetricFluent.MetadataNested<A> withNewMetadata();
    public MetricFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public MetricFluent.MetadataNested<A> editMetadata();
    public MetricFluent.MetadataNested<A> editOrNewMetadata();
    public MetricFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public MetricSpec getSpec();
    public MetricSpec buildSpec();
    public A withSpec(MetricSpec spec);
    public Boolean hasSpec();
    public MetricFluent.SpecNested<A> withNewSpec();
    public MetricFluent.SpecNested<A> withNewSpecLike(MetricSpec item);
    public MetricFluent.SpecNested<A> editSpec();
    public MetricFluent.SpecNested<A> editOrNewSpec();
    public MetricFluent.SpecNested<A> editOrNewSpecLike(MetricSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetricFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,MetricSpecFluent<MetricFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
