package me.snowdrop.istio.mixer.template.metric;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface MetricListFluent<A extends MetricListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Metric item);
    public A setToItems(int index,Metric item);
    public A addToItems(Metric... items);
    public A addAllToItems(Collection<Metric> items);
    public A removeFromItems(Metric... items);
    public A removeAllFromItems(Collection<Metric> items);
    public A removeMatchingFromItems(Predicate<MetricBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Metric> getItems();
    public List<Metric> buildItems();
    public Metric buildItem(int index);
    public Metric buildFirstItem();
    public Metric buildLastItem();
    public Metric buildMatchingItem(Predicate<MetricBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<MetricBuilder> predicate);
    public A withItems(List<Metric> items);
    public A withItems(Metric... items);
    public Boolean hasItems();
    public MetricListFluent.ItemsNested<A> addNewItem();
    public MetricListFluent.ItemsNested<A> addNewItemLike(Metric item);
    public MetricListFluent.ItemsNested<A> setNewItemLike(int index,Metric item);
    public MetricListFluent.ItemsNested<A> editItem(int index);
    public MetricListFluent.ItemsNested<A> editFirstItem();
    public MetricListFluent.ItemsNested<A> editLastItem();
    public MetricListFluent.ItemsNested<A> editMatchingItem(Predicate<MetricBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,MetricFluent<MetricListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
