package me.snowdrop.istio.mixer.template.quota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class QuotaListBuilder extends QuotaListFluentImpl<QuotaListBuilder> implements VisitableBuilder<QuotaList,QuotaListBuilder>{

    QuotaListFluent<?> fluent;
    Boolean validationEnabled;

    public QuotaListBuilder(){
            this(true);
    }
    public QuotaListBuilder(Boolean validationEnabled){
            this(new QuotaList(), validationEnabled);
    }
    public QuotaListBuilder(QuotaListFluent<?> fluent){
            this(fluent, true);
    }
    public QuotaListBuilder(QuotaListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new QuotaList(), validationEnabled);
    }
    public QuotaListBuilder(QuotaListFluent<?> fluent,QuotaList instance){
            this(fluent, instance, true);
    }
    public QuotaListBuilder(QuotaListFluent<?> fluent,QuotaList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaListBuilder(QuotaList instance){
            this(instance,true);
    }
    public QuotaListBuilder(QuotaList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public QuotaList build(){
            QuotaList buildable = new QuotaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            QuotaListBuilder that = (QuotaListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
