
package me.snowdrop.istio.mixer.template.quota;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.cexl.TypedValue;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "dimensions",
    "name"
})
@IstioKind(name = "quota", plural = "quotas")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class QuotaSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("dimensions")
    @JsonPropertyDescription("")
    private Map<String, TypedValue> dimensions;
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    private final static long serialVersionUID = 8012096076626944214L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public QuotaSpec() {
    }

    /**
     * 
     * @param name
     * @param dimensions
     */
    public QuotaSpec(Map<String, TypedValue> dimensions, java.lang.String name) {
        super();
        this.dimensions = dimensions;
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("dimensions")
    public Map<String, TypedValue> getDimensions() {
        return dimensions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("dimensions")
    public void setDimensions(Map<String, TypedValue> dimensions) {
        this.dimensions = dimensions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

}
