package me.snowdrop.istio.mixer.template.reportnothing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReportNothingListBuilder extends ReportNothingListFluentImpl<ReportNothingListBuilder> implements VisitableBuilder<ReportNothingList,ReportNothingListBuilder>{

    ReportNothingListFluent<?> fluent;
    Boolean validationEnabled;

    public ReportNothingListBuilder(){
            this(true);
    }
    public ReportNothingListBuilder(Boolean validationEnabled){
            this(new ReportNothingList(), validationEnabled);
    }
    public ReportNothingListBuilder(ReportNothingListFluent<?> fluent){
            this(fluent, true);
    }
    public ReportNothingListBuilder(ReportNothingListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReportNothingList(), validationEnabled);
    }
    public ReportNothingListBuilder(ReportNothingListFluent<?> fluent,ReportNothingList instance){
            this(fluent, instance, true);
    }
    public ReportNothingListBuilder(ReportNothingListFluent<?> fluent,ReportNothingList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReportNothingListBuilder(ReportNothingList instance){
            this(instance,true);
    }
    public ReportNothingListBuilder(ReportNothingList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ReportNothingList build(){
            ReportNothingList buildable = new ReportNothingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReportNothingListBuilder that = (ReportNothingListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
