package me.snowdrop.istio.mixer.template.reportnothing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReportNothingSpecBuilder extends ReportNothingSpecFluentImpl<ReportNothingSpecBuilder> implements VisitableBuilder<ReportNothingSpec,ReportNothingSpecBuilder>{

    ReportNothingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ReportNothingSpecBuilder(){
            this(true);
    }
    public ReportNothingSpecBuilder(Boolean validationEnabled){
            this(new ReportNothingSpec(), validationEnabled);
    }
    public ReportNothingSpecBuilder(ReportNothingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ReportNothingSpecBuilder(ReportNothingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReportNothingSpec(), validationEnabled);
    }
    public ReportNothingSpecBuilder(ReportNothingSpecFluent<?> fluent,ReportNothingSpec instance){
            this(fluent, instance, true);
    }
    public ReportNothingSpecBuilder(ReportNothingSpecFluent<?> fluent,ReportNothingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReportNothingSpecBuilder(ReportNothingSpec instance){
            this(instance,true);
    }
    public ReportNothingSpecBuilder(ReportNothingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public ReportNothingSpec build(){
            ReportNothingSpec buildable = new ReportNothingSpec(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReportNothingSpecBuilder that = (ReportNothingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
