package me.snowdrop.istio.mixer.template.tracespan;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TraceSpanBuilder extends TraceSpanFluentImpl<TraceSpanBuilder> implements VisitableBuilder<TraceSpan,TraceSpanBuilder>{

    TraceSpanFluent<?> fluent;
    Boolean validationEnabled;

    public TraceSpanBuilder(){
            this(true);
    }
    public TraceSpanBuilder(Boolean validationEnabled){
            this(new TraceSpan(), validationEnabled);
    }
    public TraceSpanBuilder(TraceSpanFluent<?> fluent){
            this(fluent, true);
    }
    public TraceSpanBuilder(TraceSpanFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TraceSpan(), validationEnabled);
    }
    public TraceSpanBuilder(TraceSpanFluent<?> fluent,TraceSpan instance){
            this(fluent, instance, true);
    }
    public TraceSpanBuilder(TraceSpanFluent<?> fluent,TraceSpan instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public TraceSpanBuilder(TraceSpan instance){
            this(instance,true);
    }
    public TraceSpanBuilder(TraceSpan instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public TraceSpan build(){
            TraceSpan buildable = new TraceSpan(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TraceSpanBuilder that = (TraceSpanBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
