package me.snowdrop.istio.mixer.template.tracespan;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TraceSpanListBuilder extends TraceSpanListFluentImpl<TraceSpanListBuilder> implements VisitableBuilder<TraceSpanList,TraceSpanListBuilder>{

    TraceSpanListFluent<?> fluent;
    Boolean validationEnabled;

    public TraceSpanListBuilder(){
            this(true);
    }
    public TraceSpanListBuilder(Boolean validationEnabled){
            this(new TraceSpanList(), validationEnabled);
    }
    public TraceSpanListBuilder(TraceSpanListFluent<?> fluent){
            this(fluent, true);
    }
    public TraceSpanListBuilder(TraceSpanListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TraceSpanList(), validationEnabled);
    }
    public TraceSpanListBuilder(TraceSpanListFluent<?> fluent,TraceSpanList instance){
            this(fluent, instance, true);
    }
    public TraceSpanListBuilder(TraceSpanListFluent<?> fluent,TraceSpanList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public TraceSpanListBuilder(TraceSpanList instance){
            this(instance,true);
    }
    public TraceSpanListBuilder(TraceSpanList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public TraceSpanList build(){
            TraceSpanList buildable = new TraceSpanList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TraceSpanListBuilder that = (TraceSpanListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
