
package me.snowdrop.istio.mixer.template.tracespan;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.TimeStamp;
import me.snowdrop.istio.api.cexl.TypedValue;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;
import me.snowdrop.istio.api.policy.v1beta1.IPAddress;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "apiProtocol",
    "clientSpan",
    "destinationIp",
    "destinationName",
    "endTime",
    "httpStatusCode",
    "name",
    "parentSpanId",
    "requestSize",
    "requestTotalSize",
    "responseSize",
    "responseTotalSize",
    "rewriteClientSpanId",
    "sourceIp",
    "sourceName",
    "spanId",
    "spanName",
    "spanTags",
    "startTime",
    "traceId"
})
@IstioKind(name = "tracespan", plural = "tracespans")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class TraceSpanSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("apiProtocol")
    @JsonPropertyDescription("")
    private java.lang.String apiProtocol;
    /**
     * 
     * 
     */
    @JsonProperty("clientSpan")
    @JsonPropertyDescription("")
    private Boolean clientSpan;
    /**
     * 
     * 
     */
    @JsonProperty("destinationIp")
    @JsonPropertyDescription("")
    private IPAddress destinationIp;
    /**
     * 
     * 
     */
    @JsonProperty("destinationName")
    @JsonPropertyDescription("")
    private java.lang.String destinationName;
    /**
     * 
     * 
     */
    @JsonProperty("endTime")
    @JsonPropertyDescription("")
    private TimeStamp endTime;
    /**
     * 
     * 
     */
    @JsonProperty("httpStatusCode")
    @JsonPropertyDescription("")
    private Integer httpStatusCode;
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    /**
     * 
     * 
     */
    @JsonProperty("parentSpanId")
    @JsonPropertyDescription("")
    private java.lang.String parentSpanId;
    /**
     * 
     * 
     */
    @JsonProperty("requestSize")
    @JsonPropertyDescription("")
    private Integer requestSize;
    /**
     * 
     * 
     */
    @JsonProperty("requestTotalSize")
    @JsonPropertyDescription("")
    private Integer requestTotalSize;
    /**
     * 
     * 
     */
    @JsonProperty("responseSize")
    @JsonPropertyDescription("")
    private Integer responseSize;
    /**
     * 
     * 
     */
    @JsonProperty("responseTotalSize")
    @JsonPropertyDescription("")
    private Integer responseTotalSize;
    /**
     * 
     * 
     */
    @JsonProperty("rewriteClientSpanId")
    @JsonPropertyDescription("")
    private Boolean rewriteClientSpanId;
    /**
     * 
     * 
     */
    @JsonProperty("sourceIp")
    @JsonPropertyDescription("")
    private IPAddress sourceIp;
    /**
     * 
     * 
     */
    @JsonProperty("sourceName")
    @JsonPropertyDescription("")
    private java.lang.String sourceName;
    /**
     * 
     * 
     */
    @JsonProperty("spanId")
    @JsonPropertyDescription("")
    private java.lang.String spanId;
    /**
     * 
     * 
     */
    @JsonProperty("spanName")
    @JsonPropertyDescription("")
    private java.lang.String spanName;
    /**
     * 
     * 
     */
    @JsonProperty("spanTags")
    @JsonPropertyDescription("")
    private Map<String, TypedValue> spanTags;
    /**
     * 
     * 
     */
    @JsonProperty("startTime")
    @JsonPropertyDescription("")
    private TimeStamp startTime;
    /**
     * 
     * 
     */
    @JsonProperty("traceId")
    @JsonPropertyDescription("")
    private java.lang.String traceId;
    private final static long serialVersionUID = 3318430285910286850L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TraceSpanSpec() {
    }

    /**
     * 
     * @param clientSpan
     * @param traceId
     * @param requestTotalSize
     * @param responseSize
     * @param responseTotalSize
     * @param apiProtocol
     * @param parentSpanId
     * @param spanName
     * @param destinationIp
     * @param spanId
     * @param rewriteClientSpanId
     * @param sourceIp
     * @param destinationName
     * @param name
     * @param startTime
     * @param endTime
     * @param sourceName
     * @param requestSize
     * @param httpStatusCode
     * @param spanTags
     */
    public TraceSpanSpec(java.lang.String apiProtocol, Boolean clientSpan, IPAddress destinationIp, java.lang.String destinationName, TimeStamp endTime, Integer httpStatusCode, java.lang.String name, java.lang.String parentSpanId, Integer requestSize, Integer requestTotalSize, Integer responseSize, Integer responseTotalSize, Boolean rewriteClientSpanId, IPAddress sourceIp, java.lang.String sourceName, java.lang.String spanId, java.lang.String spanName, Map<String, TypedValue> spanTags, TimeStamp startTime, java.lang.String traceId) {
        super();
        this.apiProtocol = apiProtocol;
        this.clientSpan = clientSpan;
        this.destinationIp = destinationIp;
        this.destinationName = destinationName;
        this.endTime = endTime;
        this.httpStatusCode = httpStatusCode;
        this.name = name;
        this.parentSpanId = parentSpanId;
        this.requestSize = requestSize;
        this.requestTotalSize = requestTotalSize;
        this.responseSize = responseSize;
        this.responseTotalSize = responseTotalSize;
        this.rewriteClientSpanId = rewriteClientSpanId;
        this.sourceIp = sourceIp;
        this.sourceName = sourceName;
        this.spanId = spanId;
        this.spanName = spanName;
        this.spanTags = spanTags;
        this.startTime = startTime;
        this.traceId = traceId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiProtocol")
    public java.lang.String getApiProtocol() {
        return apiProtocol;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiProtocol")
    public void setApiProtocol(java.lang.String apiProtocol) {
        this.apiProtocol = apiProtocol;
    }

    /**
     * 
     * 
     */
    @JsonProperty("clientSpan")
    public Boolean getClientSpan() {
        return clientSpan;
    }

    /**
     * 
     * 
     */
    @JsonProperty("clientSpan")
    public void setClientSpan(Boolean clientSpan) {
        this.clientSpan = clientSpan;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationIp")
    public IPAddress getDestinationIp() {
        return destinationIp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationIp")
    public void setDestinationIp(IPAddress destinationIp) {
        this.destinationIp = destinationIp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationName")
    public java.lang.String getDestinationName() {
        return destinationName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationName")
    public void setDestinationName(java.lang.String destinationName) {
        this.destinationName = destinationName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("endTime")
    public TimeStamp getEndTime() {
        return endTime;
    }

    /**
     * 
     * 
     */
    @JsonProperty("endTime")
    public void setEndTime(TimeStamp endTime) {
        this.endTime = endTime;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpStatusCode")
    public Integer getHttpStatusCode() {
        return httpStatusCode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpStatusCode")
    public void setHttpStatusCode(Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("parentSpanId")
    public java.lang.String getParentSpanId() {
        return parentSpanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("parentSpanId")
    public void setParentSpanId(java.lang.String parentSpanId) {
        this.parentSpanId = parentSpanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("requestSize")
    public Integer getRequestSize() {
        return requestSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("requestSize")
    public void setRequestSize(Integer requestSize) {
        this.requestSize = requestSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("requestTotalSize")
    public Integer getRequestTotalSize() {
        return requestTotalSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("requestTotalSize")
    public void setRequestTotalSize(Integer requestTotalSize) {
        this.requestTotalSize = requestTotalSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("responseSize")
    public Integer getResponseSize() {
        return responseSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("responseSize")
    public void setResponseSize(Integer responseSize) {
        this.responseSize = responseSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("responseTotalSize")
    public Integer getResponseTotalSize() {
        return responseTotalSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("responseTotalSize")
    public void setResponseTotalSize(Integer responseTotalSize) {
        this.responseTotalSize = responseTotalSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rewriteClientSpanId")
    public Boolean getRewriteClientSpanId() {
        return rewriteClientSpanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rewriteClientSpanId")
    public void setRewriteClientSpanId(Boolean rewriteClientSpanId) {
        this.rewriteClientSpanId = rewriteClientSpanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceIp")
    public IPAddress getSourceIp() {
        return sourceIp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceIp")
    public void setSourceIp(IPAddress sourceIp) {
        this.sourceIp = sourceIp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceName")
    public java.lang.String getSourceName() {
        return sourceName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceName")
    public void setSourceName(java.lang.String sourceName) {
        this.sourceName = sourceName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanId")
    public java.lang.String getSpanId() {
        return spanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanId")
    public void setSpanId(java.lang.String spanId) {
        this.spanId = spanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanName")
    public java.lang.String getSpanName() {
        return spanName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanName")
    public void setSpanName(java.lang.String spanName) {
        this.spanName = spanName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanTags")
    public Map<String, TypedValue> getSpanTags() {
        return spanTags;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanTags")
    public void setSpanTags(Map<String, TypedValue> spanTags) {
        this.spanTags = spanTags;
    }

    /**
     * 
     * 
     */
    @JsonProperty("startTime")
    public TimeStamp getStartTime() {
        return startTime;
    }

    /**
     * 
     * 
     */
    @JsonProperty("startTime")
    public void setStartTime(TimeStamp startTime) {
        this.startTime = startTime;
    }

    /**
     * 
     * 
     */
    @JsonProperty("traceId")
    public java.lang.String getTraceId() {
        return traceId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("traceId")
    public void setTraceId(java.lang.String traceId) {
        this.traceId = traceId;
    }

}
