package me.snowdrop.istio.mixer.template.tracespan;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TraceSpanSpecBuilder extends TraceSpanSpecFluentImpl<TraceSpanSpecBuilder> implements VisitableBuilder<TraceSpanSpec,TraceSpanSpecBuilder>{

    TraceSpanSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TraceSpanSpecBuilder(){
            this(true);
    }
    public TraceSpanSpecBuilder(Boolean validationEnabled){
            this(new TraceSpanSpec(), validationEnabled);
    }
    public TraceSpanSpecBuilder(TraceSpanSpecFluent<?> fluent){
            this(fluent, true);
    }
    public TraceSpanSpecBuilder(TraceSpanSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TraceSpanSpec(), validationEnabled);
    }
    public TraceSpanSpecBuilder(TraceSpanSpecFluent<?> fluent,TraceSpanSpec instance){
            this(fluent, instance, true);
    }
    public TraceSpanSpecBuilder(TraceSpanSpecFluent<?> fluent,TraceSpanSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiProtocol(instance.getApiProtocol()); 
            fluent.withClientSpan(instance.getClientSpan()); 
            fluent.withDestinationIp(instance.getDestinationIp()); 
            fluent.withDestinationName(instance.getDestinationName()); 
            fluent.withEndTime(instance.getEndTime()); 
            fluent.withHttpStatusCode(instance.getHttpStatusCode()); 
            fluent.withName(instance.getName()); 
            fluent.withParentSpanId(instance.getParentSpanId()); 
            fluent.withRequestSize(instance.getRequestSize()); 
            fluent.withRequestTotalSize(instance.getRequestTotalSize()); 
            fluent.withResponseSize(instance.getResponseSize()); 
            fluent.withResponseTotalSize(instance.getResponseTotalSize()); 
            fluent.withRewriteClientSpanId(instance.getRewriteClientSpanId()); 
            fluent.withSourceIp(instance.getSourceIp()); 
            fluent.withSourceName(instance.getSourceName()); 
            fluent.withSpanId(instance.getSpanId()); 
            fluent.withSpanName(instance.getSpanName()); 
            fluent.withSpanTags(instance.getSpanTags()); 
            fluent.withStartTime(instance.getStartTime()); 
            fluent.withTraceId(instance.getTraceId()); 
            this.validationEnabled = validationEnabled; 
    }
    public TraceSpanSpecBuilder(TraceSpanSpec instance){
            this(instance,true);
    }
    public TraceSpanSpecBuilder(TraceSpanSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiProtocol(instance.getApiProtocol()); 
            this.withClientSpan(instance.getClientSpan()); 
            this.withDestinationIp(instance.getDestinationIp()); 
            this.withDestinationName(instance.getDestinationName()); 
            this.withEndTime(instance.getEndTime()); 
            this.withHttpStatusCode(instance.getHttpStatusCode()); 
            this.withName(instance.getName()); 
            this.withParentSpanId(instance.getParentSpanId()); 
            this.withRequestSize(instance.getRequestSize()); 
            this.withRequestTotalSize(instance.getRequestTotalSize()); 
            this.withResponseSize(instance.getResponseSize()); 
            this.withResponseTotalSize(instance.getResponseTotalSize()); 
            this.withRewriteClientSpanId(instance.getRewriteClientSpanId()); 
            this.withSourceIp(instance.getSourceIp()); 
            this.withSourceName(instance.getSourceName()); 
            this.withSpanId(instance.getSpanId()); 
            this.withSpanName(instance.getSpanName()); 
            this.withSpanTags(instance.getSpanTags()); 
            this.withStartTime(instance.getStartTime()); 
            this.withTraceId(instance.getTraceId()); 
            this.validationEnabled = validationEnabled; 
    }

    public TraceSpanSpec build(){
            TraceSpanSpec buildable = new TraceSpanSpec(fluent.getApiProtocol(),fluent.isClientSpan(),fluent.getDestinationIp(),fluent.getDestinationName(),fluent.getEndTime(),fluent.getHttpStatusCode(),fluent.getName(),fluent.getParentSpanId(),fluent.getRequestSize(),fluent.getRequestTotalSize(),fluent.getResponseSize(),fluent.getResponseTotalSize(),fluent.isRewriteClientSpanId(),fluent.getSourceIp(),fluent.getSourceName(),fluent.getSpanId(),fluent.getSpanName(),fluent.getSpanTags(),fluent.getStartTime(),fluent.getTraceId());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TraceSpanSpecBuilder that = (TraceSpanSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
