package me.snowdrop.istio.mixer.template.tracespan;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.TimeStampBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import me.snowdrop.istio.api.TimeStampFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.cexl.TypedValue;
import me.snowdrop.istio.api.policy.v1beta1.IPAddressFluentImpl;
import me.snowdrop.istio.api.TimeStamp;
import java.lang.Integer;
import me.snowdrop.istio.api.policy.v1beta1.IPAddressBuilder;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.policy.v1beta1.IPAddress;
import java.util.Map;

public class TraceSpanSpecFluentImpl<A extends TraceSpanSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TraceSpanSpecFluent<A>{

    private String apiProtocol;
    private Boolean clientSpan;
    private IPAddressBuilder destinationIp;
    private String destinationName;
    private TimeStampBuilder endTime;
    private Integer httpStatusCode;
    private String name;
    private String parentSpanId;
    private Integer requestSize;
    private Integer requestTotalSize;
    private Integer responseSize;
    private Integer responseTotalSize;
    private Boolean rewriteClientSpanId;
    private IPAddressBuilder sourceIp;
    private String sourceName;
    private String spanId;
    private String spanName;
    private Map<String,TypedValue> spanTags;
    private TimeStampBuilder startTime;
    private String traceId;

    public TraceSpanSpecFluentImpl(){
    }
    public TraceSpanSpecFluentImpl(TraceSpanSpec instance){
            this.withApiProtocol(instance.getApiProtocol()); 
            this.withClientSpan(instance.getClientSpan()); 
            this.withDestinationIp(instance.getDestinationIp()); 
            this.withDestinationName(instance.getDestinationName()); 
            this.withEndTime(instance.getEndTime()); 
            this.withHttpStatusCode(instance.getHttpStatusCode()); 
            this.withName(instance.getName()); 
            this.withParentSpanId(instance.getParentSpanId()); 
            this.withRequestSize(instance.getRequestSize()); 
            this.withRequestTotalSize(instance.getRequestTotalSize()); 
            this.withResponseSize(instance.getResponseSize()); 
            this.withResponseTotalSize(instance.getResponseTotalSize()); 
            this.withRewriteClientSpanId(instance.getRewriteClientSpanId()); 
            this.withSourceIp(instance.getSourceIp()); 
            this.withSourceName(instance.getSourceName()); 
            this.withSpanId(instance.getSpanId()); 
            this.withSpanName(instance.getSpanName()); 
            this.withSpanTags(instance.getSpanTags()); 
            this.withStartTime(instance.getStartTime()); 
            this.withTraceId(instance.getTraceId()); 
    }

    public String getApiProtocol(){
            return this.apiProtocol;
    }

    public A withApiProtocol(String apiProtocol){
            this.apiProtocol=apiProtocol; return (A) this;
    }

    public Boolean hasApiProtocol(){
            return this.apiProtocol != null;
    }

    public A withNewApiProtocol(String arg1){
            return (A)withApiProtocol(new String(arg1));
    }

    public A withNewApiProtocol(StringBuilder arg1){
            return (A)withApiProtocol(new String(arg1));
    }

    public A withNewApiProtocol(StringBuffer arg1){
            return (A)withApiProtocol(new String(arg1));
    }

    public Boolean isClientSpan(){
            return this.clientSpan;
    }

    public A withClientSpan(Boolean clientSpan){
            this.clientSpan=clientSpan; return (A) this;
    }

    public Boolean hasClientSpan(){
            return this.clientSpan != null;
    }

    public A withNewClientSpan(String arg1){
            return (A)withClientSpan(new Boolean(arg1));
    }

    public A withNewClientSpan(boolean arg1){
            return (A)withClientSpan(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildDestinationIp instead.
 * @return The buildable object.
 */
@Deprecated public IPAddress getDestinationIp(){
            return this.destinationIp!=null?this.destinationIp.build():null;
    }

    public IPAddress buildDestinationIp(){
            return this.destinationIp!=null?this.destinationIp.build():null;
    }

    public A withDestinationIp(IPAddress destinationIp){
            _visitables.get("destinationIp").remove(this.destinationIp);
            if (destinationIp!=null){ this.destinationIp= new IPAddressBuilder(destinationIp); _visitables.get("destinationIp").add(this.destinationIp);} return (A) this;
    }

    public Boolean hasDestinationIp(){
            return this.destinationIp != null;
    }

    public A withNewDestinationIp(String value){
            return (A)withDestinationIp(new IPAddress(value));
    }

    public TraceSpanSpecFluent.DestinationIpNested<A> withNewDestinationIp(){
            return new DestinationIpNestedImpl();
    }

    public TraceSpanSpecFluent.DestinationIpNested<A> withNewDestinationIpLike(IPAddress item){
            return new DestinationIpNestedImpl(item);
    }

    public TraceSpanSpecFluent.DestinationIpNested<A> editDestinationIp(){
            return withNewDestinationIpLike(getDestinationIp());
    }

    public TraceSpanSpecFluent.DestinationIpNested<A> editOrNewDestinationIp(){
            return withNewDestinationIpLike(getDestinationIp() != null ? getDestinationIp(): new IPAddressBuilder().build());
    }

    public TraceSpanSpecFluent.DestinationIpNested<A> editOrNewDestinationIpLike(IPAddress item){
            return withNewDestinationIpLike(getDestinationIp() != null ? getDestinationIp(): item);
    }

    public String getDestinationName(){
            return this.destinationName;
    }

    public A withDestinationName(String destinationName){
            this.destinationName=destinationName; return (A) this;
    }

    public Boolean hasDestinationName(){
            return this.destinationName != null;
    }

    public A withNewDestinationName(String arg1){
            return (A)withDestinationName(new String(arg1));
    }

    public A withNewDestinationName(StringBuilder arg1){
            return (A)withDestinationName(new String(arg1));
    }

    public A withNewDestinationName(StringBuffer arg1){
            return (A)withDestinationName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildEndTime instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getEndTime(){
            return this.endTime!=null?this.endTime.build():null;
    }

    public TimeStamp buildEndTime(){
            return this.endTime!=null?this.endTime.build():null;
    }

    public A withEndTime(TimeStamp endTime){
            _visitables.get("endTime").remove(this.endTime);
            if (endTime!=null){ this.endTime= new TimeStampBuilder(endTime); _visitables.get("endTime").add(this.endTime);} return (A) this;
    }

    public Boolean hasEndTime(){
            return this.endTime != null;
    }

    public A withNewEndTime(Integer nanos,Long seconds){
            return (A)withEndTime(new TimeStamp(nanos, seconds));
    }

    public TraceSpanSpecFluent.EndTimeNested<A> withNewEndTime(){
            return new EndTimeNestedImpl();
    }

    public TraceSpanSpecFluent.EndTimeNested<A> withNewEndTimeLike(TimeStamp item){
            return new EndTimeNestedImpl(item);
    }

    public TraceSpanSpecFluent.EndTimeNested<A> editEndTime(){
            return withNewEndTimeLike(getEndTime());
    }

    public TraceSpanSpecFluent.EndTimeNested<A> editOrNewEndTime(){
            return withNewEndTimeLike(getEndTime() != null ? getEndTime(): new TimeStampBuilder().build());
    }

    public TraceSpanSpecFluent.EndTimeNested<A> editOrNewEndTimeLike(TimeStamp item){
            return withNewEndTimeLike(getEndTime() != null ? getEndTime(): item);
    }

    public Integer getHttpStatusCode(){
            return this.httpStatusCode;
    }

    public A withHttpStatusCode(Integer httpStatusCode){
            this.httpStatusCode=httpStatusCode; return (A) this;
    }

    public Boolean hasHttpStatusCode(){
            return this.httpStatusCode != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getParentSpanId(){
            return this.parentSpanId;
    }

    public A withParentSpanId(String parentSpanId){
            this.parentSpanId=parentSpanId; return (A) this;
    }

    public Boolean hasParentSpanId(){
            return this.parentSpanId != null;
    }

    public A withNewParentSpanId(String arg1){
            return (A)withParentSpanId(new String(arg1));
    }

    public A withNewParentSpanId(StringBuilder arg1){
            return (A)withParentSpanId(new String(arg1));
    }

    public A withNewParentSpanId(StringBuffer arg1){
            return (A)withParentSpanId(new String(arg1));
    }

    public Integer getRequestSize(){
            return this.requestSize;
    }

    public A withRequestSize(Integer requestSize){
            this.requestSize=requestSize; return (A) this;
    }

    public Boolean hasRequestSize(){
            return this.requestSize != null;
    }

    public Integer getRequestTotalSize(){
            return this.requestTotalSize;
    }

    public A withRequestTotalSize(Integer requestTotalSize){
            this.requestTotalSize=requestTotalSize; return (A) this;
    }

    public Boolean hasRequestTotalSize(){
            return this.requestTotalSize != null;
    }

    public Integer getResponseSize(){
            return this.responseSize;
    }

    public A withResponseSize(Integer responseSize){
            this.responseSize=responseSize; return (A) this;
    }

    public Boolean hasResponseSize(){
            return this.responseSize != null;
    }

    public Integer getResponseTotalSize(){
            return this.responseTotalSize;
    }

    public A withResponseTotalSize(Integer responseTotalSize){
            this.responseTotalSize=responseTotalSize; return (A) this;
    }

    public Boolean hasResponseTotalSize(){
            return this.responseTotalSize != null;
    }

    public Boolean isRewriteClientSpanId(){
            return this.rewriteClientSpanId;
    }

    public A withRewriteClientSpanId(Boolean rewriteClientSpanId){
            this.rewriteClientSpanId=rewriteClientSpanId; return (A) this;
    }

    public Boolean hasRewriteClientSpanId(){
            return this.rewriteClientSpanId != null;
    }

    public A withNewRewriteClientSpanId(String arg1){
            return (A)withRewriteClientSpanId(new Boolean(arg1));
    }

    public A withNewRewriteClientSpanId(boolean arg1){
            return (A)withRewriteClientSpanId(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSourceIp instead.
 * @return The buildable object.
 */
@Deprecated public IPAddress getSourceIp(){
            return this.sourceIp!=null?this.sourceIp.build():null;
    }

    public IPAddress buildSourceIp(){
            return this.sourceIp!=null?this.sourceIp.build():null;
    }

    public A withSourceIp(IPAddress sourceIp){
            _visitables.get("sourceIp").remove(this.sourceIp);
            if (sourceIp!=null){ this.sourceIp= new IPAddressBuilder(sourceIp); _visitables.get("sourceIp").add(this.sourceIp);} return (A) this;
    }

    public Boolean hasSourceIp(){
            return this.sourceIp != null;
    }

    public A withNewSourceIp(String value){
            return (A)withSourceIp(new IPAddress(value));
    }

    public TraceSpanSpecFluent.SourceIpNested<A> withNewSourceIp(){
            return new SourceIpNestedImpl();
    }

    public TraceSpanSpecFluent.SourceIpNested<A> withNewSourceIpLike(IPAddress item){
            return new SourceIpNestedImpl(item);
    }

    public TraceSpanSpecFluent.SourceIpNested<A> editSourceIp(){
            return withNewSourceIpLike(getSourceIp());
    }

    public TraceSpanSpecFluent.SourceIpNested<A> editOrNewSourceIp(){
            return withNewSourceIpLike(getSourceIp() != null ? getSourceIp(): new IPAddressBuilder().build());
    }

    public TraceSpanSpecFluent.SourceIpNested<A> editOrNewSourceIpLike(IPAddress item){
            return withNewSourceIpLike(getSourceIp() != null ? getSourceIp(): item);
    }

    public String getSourceName(){
            return this.sourceName;
    }

    public A withSourceName(String sourceName){
            this.sourceName=sourceName; return (A) this;
    }

    public Boolean hasSourceName(){
            return this.sourceName != null;
    }

    public A withNewSourceName(String arg1){
            return (A)withSourceName(new String(arg1));
    }

    public A withNewSourceName(StringBuilder arg1){
            return (A)withSourceName(new String(arg1));
    }

    public A withNewSourceName(StringBuffer arg1){
            return (A)withSourceName(new String(arg1));
    }

    public String getSpanId(){
            return this.spanId;
    }

    public A withSpanId(String spanId){
            this.spanId=spanId; return (A) this;
    }

    public Boolean hasSpanId(){
            return this.spanId != null;
    }

    public A withNewSpanId(String arg1){
            return (A)withSpanId(new String(arg1));
    }

    public A withNewSpanId(StringBuilder arg1){
            return (A)withSpanId(new String(arg1));
    }

    public A withNewSpanId(StringBuffer arg1){
            return (A)withSpanId(new String(arg1));
    }

    public String getSpanName(){
            return this.spanName;
    }

    public A withSpanName(String spanName){
            this.spanName=spanName; return (A) this;
    }

    public Boolean hasSpanName(){
            return this.spanName != null;
    }

    public A withNewSpanName(String arg1){
            return (A)withSpanName(new String(arg1));
    }

    public A withNewSpanName(StringBuilder arg1){
            return (A)withSpanName(new String(arg1));
    }

    public A withNewSpanName(StringBuffer arg1){
            return (A)withSpanName(new String(arg1));
    }

    public A addToSpanTags(String key,TypedValue value){
            if(this.spanTags == null && key != null && value != null) { this.spanTags = new LinkedHashMap<String,TypedValue>(); }
            if(key != null && value != null) {this.spanTags.put(key, value);} return (A)this;
    }

    public A addToSpanTags(Map<String,TypedValue> map){
            if(this.spanTags == null && map != null) { this.spanTags = new LinkedHashMap<String,TypedValue>(); }
            if(map != null) { this.spanTags.putAll(map);} return (A)this;
    }

    public A removeFromSpanTags(String key){
            if(this.spanTags == null) { return (A) this; }
            if(key != null && this.spanTags != null) {this.spanTags.remove(key);} return (A)this;
    }

    public A removeFromSpanTags(Map<String,TypedValue> map){
            if(this.spanTags == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.spanTags != null){this.spanTags.remove(key);}}} return (A)this;
    }

    public Map<String,TypedValue> getSpanTags(){
            return this.spanTags;
    }

    public A withSpanTags(Map<String,TypedValue> spanTags){
            if (spanTags == null) { this.spanTags =  null;} else {this.spanTags = new LinkedHashMap<String,TypedValue>(spanTags);} return (A) this;
    }

    public Boolean hasSpanTags(){
            return this.spanTags != null;
    }

    
/**
 * This method has been deprecated, please use method buildStartTime instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getStartTime(){
            return this.startTime!=null?this.startTime.build():null;
    }

    public TimeStamp buildStartTime(){
            return this.startTime!=null?this.startTime.build():null;
    }

    public A withStartTime(TimeStamp startTime){
            _visitables.get("startTime").remove(this.startTime);
            if (startTime!=null){ this.startTime= new TimeStampBuilder(startTime); _visitables.get("startTime").add(this.startTime);} return (A) this;
    }

    public Boolean hasStartTime(){
            return this.startTime != null;
    }

    public A withNewStartTime(Integer nanos,Long seconds){
            return (A)withStartTime(new TimeStamp(nanos, seconds));
    }

    public TraceSpanSpecFluent.StartTimeNested<A> withNewStartTime(){
            return new StartTimeNestedImpl();
    }

    public TraceSpanSpecFluent.StartTimeNested<A> withNewStartTimeLike(TimeStamp item){
            return new StartTimeNestedImpl(item);
    }

    public TraceSpanSpecFluent.StartTimeNested<A> editStartTime(){
            return withNewStartTimeLike(getStartTime());
    }

    public TraceSpanSpecFluent.StartTimeNested<A> editOrNewStartTime(){
            return withNewStartTimeLike(getStartTime() != null ? getStartTime(): new TimeStampBuilder().build());
    }

    public TraceSpanSpecFluent.StartTimeNested<A> editOrNewStartTimeLike(TimeStamp item){
            return withNewStartTimeLike(getStartTime() != null ? getStartTime(): item);
    }

    public String getTraceId(){
            return this.traceId;
    }

    public A withTraceId(String traceId){
            this.traceId=traceId; return (A) this;
    }

    public Boolean hasTraceId(){
            return this.traceId != null;
    }

    public A withNewTraceId(String arg1){
            return (A)withTraceId(new String(arg1));
    }

    public A withNewTraceId(StringBuilder arg1){
            return (A)withTraceId(new String(arg1));
    }

    public A withNewTraceId(StringBuffer arg1){
            return (A)withTraceId(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TraceSpanSpecFluentImpl that = (TraceSpanSpecFluentImpl) o;
            if (apiProtocol != null ? !apiProtocol.equals(that.apiProtocol) :that.apiProtocol != null) return false;
            if (clientSpan != null ? !clientSpan.equals(that.clientSpan) :that.clientSpan != null) return false;
            if (destinationIp != null ? !destinationIp.equals(that.destinationIp) :that.destinationIp != null) return false;
            if (destinationName != null ? !destinationName.equals(that.destinationName) :that.destinationName != null) return false;
            if (endTime != null ? !endTime.equals(that.endTime) :that.endTime != null) return false;
            if (httpStatusCode != null ? !httpStatusCode.equals(that.httpStatusCode) :that.httpStatusCode != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (parentSpanId != null ? !parentSpanId.equals(that.parentSpanId) :that.parentSpanId != null) return false;
            if (requestSize != null ? !requestSize.equals(that.requestSize) :that.requestSize != null) return false;
            if (requestTotalSize != null ? !requestTotalSize.equals(that.requestTotalSize) :that.requestTotalSize != null) return false;
            if (responseSize != null ? !responseSize.equals(that.responseSize) :that.responseSize != null) return false;
            if (responseTotalSize != null ? !responseTotalSize.equals(that.responseTotalSize) :that.responseTotalSize != null) return false;
            if (rewriteClientSpanId != null ? !rewriteClientSpanId.equals(that.rewriteClientSpanId) :that.rewriteClientSpanId != null) return false;
            if (sourceIp != null ? !sourceIp.equals(that.sourceIp) :that.sourceIp != null) return false;
            if (sourceName != null ? !sourceName.equals(that.sourceName) :that.sourceName != null) return false;
            if (spanId != null ? !spanId.equals(that.spanId) :that.spanId != null) return false;
            if (spanName != null ? !spanName.equals(that.spanName) :that.spanName != null) return false;
            if (spanTags != null ? !spanTags.equals(that.spanTags) :that.spanTags != null) return false;
            if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
            if (traceId != null ? !traceId.equals(that.traceId) :that.traceId != null) return false;
            return true;
    }


    public class DestinationIpNestedImpl<N> extends IPAddressFluentImpl<TraceSpanSpecFluent.DestinationIpNested<N>> implements TraceSpanSpecFluent.DestinationIpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IPAddressBuilder builder;
    
            DestinationIpNestedImpl(IPAddress item){
                    this.builder = new IPAddressBuilder(this, item);
            }
            DestinationIpNestedImpl(){
                    this.builder = new IPAddressBuilder(this);
            }
    
    public N and(){
            return (N) TraceSpanSpecFluentImpl.this.withDestinationIp(builder.build());
    }
    public N endDestinationIp(){
            return and();
    }

}
    public class EndTimeNestedImpl<N> extends TimeStampFluentImpl<TraceSpanSpecFluent.EndTimeNested<N>> implements TraceSpanSpecFluent.EndTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeStampBuilder builder;
    
            EndTimeNestedImpl(TimeStamp item){
                    this.builder = new TimeStampBuilder(this, item);
            }
            EndTimeNestedImpl(){
                    this.builder = new TimeStampBuilder(this);
            }
    
    public N and(){
            return (N) TraceSpanSpecFluentImpl.this.withEndTime(builder.build());
    }
    public N endEndTime(){
            return and();
    }

}
    public class SourceIpNestedImpl<N> extends IPAddressFluentImpl<TraceSpanSpecFluent.SourceIpNested<N>> implements TraceSpanSpecFluent.SourceIpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IPAddressBuilder builder;
    
            SourceIpNestedImpl(IPAddress item){
                    this.builder = new IPAddressBuilder(this, item);
            }
            SourceIpNestedImpl(){
                    this.builder = new IPAddressBuilder(this);
            }
    
    public N and(){
            return (N) TraceSpanSpecFluentImpl.this.withSourceIp(builder.build());
    }
    public N endSourceIp(){
            return and();
    }

}
    public class StartTimeNestedImpl<N> extends TimeStampFluentImpl<TraceSpanSpecFluent.StartTimeNested<N>> implements TraceSpanSpecFluent.StartTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeStampBuilder builder;
    
            StartTimeNestedImpl(TimeStamp item){
                    this.builder = new TimeStampBuilder(this, item);
            }
            StartTimeNestedImpl(){
                    this.builder = new TimeStampBuilder(this);
            }
    
    public N and(){
            return (N) TraceSpanSpecFluentImpl.this.withStartTime(builder.build());
    }
    public N endStartTime(){
            return and();
    }

}


}
