/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.GlobalAuthUtil;

public class AuthGithubRequest
extends AuthDefaultRequest {
    public AuthGithubRequest(AuthConfig config) {
        super(config, AuthSource.GITHUB);
    }

    public AuthGithubRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthSource.GITHUB, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HttpResponse response = this.doPostAuthorizationCode(authCallback.getCode());
        Map<String, String> res = GlobalAuthUtil.parseStringToMap(response.body());
        this.checkResponse(res.containsKey("error"), res.get("error_description"));
        return AuthToken.builder().accessToken(res.get("access_token")).scope(res.get("scope")).tokenType(res.get("token_type")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        HttpResponse response = this.doGetUserInfo(authToken);
        JSONObject object = JSONObject.parseObject((String)response.body());
        this.checkResponse(object.containsKey((Object)"error"), object.getString("error_description"));
        return AuthUser.builder().uuid(object.getString("id")).username(object.getString("login")).avatar(object.getString("avatar_url")).blog(object.getString("blog")).nickname(object.getString("name")).company(object.getString("company")).location(object.getString("location")).email(object.getString("email")).remark(object.getString("bio")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source).build();
    }

    private void checkResponse(boolean error, String error_description) {
        if (error) {
            throw new AuthException(error_description);
        }
    }
}

