/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.GlobalAuthUtil;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthMicrosoftRequest
extends AuthDefaultRequest {
    public AuthMicrosoftRequest(AuthConfig config) {
        super(config, AuthSource.MICROSOFT);
    }

    public AuthMicrosoftRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthSource.MICROSOFT, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        return this.getToken(this.accessTokenUrl(authCallback.getCode()));
    }

    private AuthToken getToken(String accessTokenUrl) {
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)accessTokenUrl).header("Host", "https://login.microsoftonline.com")).contentType("application/x-www-form-urlencoded").form(GlobalAuthUtil.parseQueryToMap(accessTokenUrl)).execute();
        String accessTokenStr = response.body();
        JSONObject accessTokenObject = JSONObject.parseObject((String)accessTokenStr);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).scope(accessTokenObject.getString("scope")).tokenType(accessTokenObject.getString("token_type")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error_description"));
        }
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String token = authToken.getAccessToken();
        String tokenType = authToken.getTokenType();
        String jwt = tokenType + " " + token;
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)this.userInfoUrl(authToken)).header("Authorization", jwt)).execute();
        String userInfo = response.body();
        JSONObject object = JSONObject.parseObject((String)userInfo);
        this.checkResponse(object);
        return AuthUser.builder().uuid(object.getString("id")).username(object.getString("userPrincipalName")).nickname(object.getString("displayName")).location(object.getString("officeLocation")).email(object.getString("mail")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source).build();
    }

    @Override
    public AuthResponse refresh(AuthToken authToken) {
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(authToken.getRefreshToken()))).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("response_mode", "query").queryParam("scope", "offline_access%20user.read%20mail.read").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("grant_type", "authorization_code").queryParam("scope", "user.read%20mail.read").queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return UrlBuilder.fromBaseUrl(this.source.refresh()).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").queryParam("scope", "user.read%20mail.read").queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }
}

