/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthKujialeRequest
extends AuthDefaultRequest {
    public AuthKujialeRequest(AuthConfig config) {
        super(config, AuthDefaultSource.KUJIALE);
    }

    public AuthKujialeRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.KUJIALE, authStateCache);
    }

    @Override
    public String authorize(String state) {
        return this.authorize(state, "get_user_info");
    }

    public String authorize(String state, String scopeStr) {
        UrlBuilder urlBuilder = UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("state", this.getRealState(state));
        if (StringUtils.isNotEmpty(scopeStr)) {
            urlBuilder.queryParam("scope", scopeStr);
        }
        return urlBuilder.build();
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        HttpResponse response = this.doPostAuthorizationCode(authCallback.getCode());
        return this.getAuthToken(response);
    }

    private AuthToken getAuthToken(HttpResponse response) {
        JSONObject accessTokenObject = this.checkResponse(response);
        JSONObject resultObject = accessTokenObject.getJSONObject("d");
        return AuthToken.builder().accessToken(resultObject.getString("accessToken")).refreshToken(resultObject.getString("refreshToken")).expireIn(resultObject.getIntValue("expiresIn")).build();
    }

    private JSONObject checkResponse(HttpResponse response) {
        String accessTokenStr = response.body();
        JSONObject accessTokenObject = JSONObject.parseObject((String)accessTokenStr);
        if (!"0".equals(accessTokenObject.getString("c"))) {
            throw new AuthException(accessTokenObject.getString("m"));
        }
        return accessTokenObject;
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        String openId = this.getOpenId(authToken);
        HttpResponse response = HttpRequest.get((String)UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("open_id", openId).build()).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        if (!"0".equals(object.getString("c"))) {
            throw new AuthException(object.getString("m"));
        }
        JSONObject resultObject = object.getJSONObject("d");
        return AuthUser.builder().username(resultObject.getString("userName")).nickname(resultObject.getString("userName")).avatar(resultObject.getString("avatar")).uuid(resultObject.getString("openId")).token(authToken).source(this.source.toString()).build();
    }

    private String getOpenId(AuthToken authToken) {
        HttpResponse response = HttpRequest.get((String)UrlBuilder.fromBaseUrl("https://oauth.kujiale.com/oauth2/auth/user").queryParam("access_token", authToken.getAccessToken()).build()).execute();
        JSONObject accessTokenObject = this.checkResponse(response);
        return accessTokenObject.getString("d");
    }

    @Override
    public AuthResponse refresh(AuthToken authToken) {
        HttpResponse response = HttpRequest.post((String)this.refreshTokenUrl(authToken.getRefreshToken())).execute();
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getAuthToken(response)).build();
    }
}

