/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.proj;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mil.nga.crs.CRS;
import mil.nga.crs.CRSException;
import mil.nga.crs.CompoundCoordinateReferenceSystem;
import mil.nga.crs.SimpleCoordinateReferenceSystem;
import mil.nga.crs.common.Axis;
import mil.nga.crs.common.CoordinateSystem;
import mil.nga.crs.common.Unit;
import mil.nga.crs.common.UnitType;
import mil.nga.crs.geo.Ellipsoid;
import mil.nga.crs.geo.Ellipsoids;
import mil.nga.crs.geo.GeoCoordinateReferenceSystem;
import mil.nga.crs.geo.GeoDatum;
import mil.nga.crs.geo.GeoDatums;
import mil.nga.crs.geo.PrimeMeridian;
import mil.nga.crs.geo.TriaxialEllipsoid;
import mil.nga.crs.operation.OperationMethod;
import mil.nga.crs.operation.OperationParameter;
import mil.nga.crs.projected.MapProjection;
import mil.nga.crs.projected.ProjectedCoordinateReferenceSystem;
import mil.nga.crs.util.proj.ProjParser;
import mil.nga.crs.wkt.CRSKeyword;
import mil.nga.crs.wkt.CRSReader;
import mil.nga.proj.ProjectionException;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.Registry;
import org.locationtech.proj4j.datum.Datum;
import org.locationtech.proj4j.parser.DatumParameters;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.units.DegreeUnit;
import org.locationtech.proj4j.units.Units;

public class CRSParser {
    private static final CRSFactory crsFactory = new CRSFactory();
    private static final Map<String, Datum> datums = new HashMap<String, Datum>();
    private static final Map<String, org.locationtech.proj4j.datum.Ellipsoid> ellipsoids = new HashMap<String, org.locationtech.proj4j.datum.Ellipsoid>();

    public static CRSFactory getCRSFactory() {
        return crsFactory;
    }

    public static Datum getDatum(String name) {
        Datum datum = null;
        GeoDatums geoDatums = GeoDatums.fromName((String)name);
        if (geoDatums != null) {
            datum = datums.get(geoDatums.getCode().toLowerCase());
        }
        return datum;
    }

    public static org.locationtech.proj4j.datum.Ellipsoid getEllipsoid(String name) {
        org.locationtech.proj4j.datum.Ellipsoid ellipsoid = null;
        Ellipsoids ellips = Ellipsoids.fromName((String)name);
        if (ellips != null) {
            ellipsoid = ellipsoids.get(ellips.getShortName().toLowerCase());
        }
        return ellipsoid;
    }

    public static CoordinateReferenceSystem parse(String wkt) {
        CRS crsObject = null;
        try {
            crsObject = CRSReader.read((String)wkt);
        }
        catch (IOException e) {
            throw new ProjectionException("Failed to parse WKT: " + wkt, e);
        }
        CoordinateReferenceSystem crs = null;
        if (crsObject != null) {
            crs = CRSParser.convert(crsObject);
        }
        return crs;
    }

    public static CoordinateReferenceSystem parseAsParams(String wkt) {
        CRS crsObject = null;
        try {
            crsObject = CRSReader.read((String)wkt);
        }
        catch (IOException e) {
            throw new ProjectionException("Failed to parse WKT: " + wkt, e);
        }
        CoordinateReferenceSystem crs = null;
        if (crsObject != null) {
            crs = CRSParser.convertAsParams(crsObject);
        }
        return crs;
    }

    public static CoordinateReferenceSystem convert(CRS crsObject) {
        CoordinateReferenceSystem crs = null;
        switch (crsObject.getType()) {
            case GEODETIC: 
            case GEOGRAPHIC: {
                crs = CRSParser.convert((GeoCoordinateReferenceSystem)crsObject);
                break;
            }
            case PROJECTED: {
                crs = CRSParser.convert((ProjectedCoordinateReferenceSystem)crsObject);
                break;
            }
            case COMPOUND: {
                crs = CRSParser.convert((CompoundCoordinateReferenceSystem)crsObject);
                break;
            }
        }
        return crs;
    }

    public static CoordinateReferenceSystem convertAsParams(CRS crsObject) {
        CoordinateReferenceSystem crs = null;
        String params = ProjParser.paramsText((CRS)crsObject);
        if (params != null) {
            crs = CRSParser.getCRSFactory().createFromParameters(crsObject.getName(), params);
        }
        return crs;
    }

    public static CoordinateReferenceSystem convert(GeoCoordinateReferenceSystem geo) {
        Datum datum = CRSParser.convertDatum(geo);
        Projection projection = CRSParser.createProjection(geo.getCoordinateSystem());
        CRSParser.updateProjection(projection, datum.getEllipsoid(), geo.getGeoDatum());
        projection.initialize();
        return new CoordinateReferenceSystem(geo.getName(), null, datum, projection);
    }

    public static CoordinateReferenceSystem convert(ProjectedCoordinateReferenceSystem projected) {
        CoordinateSystem coordinateSystem = projected.getCoordinateSystem();
        MapProjection mapProjection = projected.getMapProjection();
        OperationMethod method = mapProjection.getMethod();
        GeoDatum geoDatum = projected.getGeoDatum();
        Datum datum = CRSParser.getDatum(geoDatum.getName());
        if (datum == null) {
            org.locationtech.proj4j.datum.Ellipsoid ellipsoid = CRSParser.convert(geoDatum.getEllipsoid());
            DatumParameters datumParameters = new DatumParameters();
            if (projected.hasIdentifiers() && projected.getIdentifier(0).getNameAndUniqueIdentifier().equalsIgnoreCase("EPSG:3857")) {
                datumParameters.setA(ellipsoid.getA());
                datumParameters.setES(0.0);
            } else {
                datumParameters.setEllipsoid(ellipsoid);
            }
            datumParameters.setDatumTransform(CRSParser.convertDatumTransform(method));
            datum = datumParameters.getDatum();
        }
        Projection projection = CRSParser.createProjection(coordinateSystem, mapProjection);
        CRSParser.updateUnits(projection, coordinateSystem);
        CRSParser.updateProjection(projection, datum.getEllipsoid(), geoDatum);
        CRSParser.updateParams(projection, method, coordinateSystem.getUnit());
        projection.initialize();
        return new CoordinateReferenceSystem(projected.getName(), null, datum, projection);
    }

    public static CoordinateReferenceSystem convert(CompoundCoordinateReferenceSystem compound) {
        SimpleCoordinateReferenceSystem simpleCrs;
        CoordinateReferenceSystem crs = null;
        Iterator iterator = compound.getCoordinateReferenceSystems().iterator();
        while (iterator.hasNext() && (crs = CRSParser.convert((CRS)(simpleCrs = (SimpleCoordinateReferenceSystem)iterator.next()))) == null) {
        }
        return crs;
    }

    public static Datum convertDatum(GeoCoordinateReferenceSystem geo) {
        double[] transform = CRSParser.convertDatumTransform((CRS)geo);
        return CRSParser.convert(geo.getGeoDatum(), transform);
    }

    public static Datum convert(GeoDatum geoDatum) {
        return CRSParser.convert(geoDatum, null);
    }

    public static Datum convert(GeoDatum geoDatum, double[] transform) {
        String name = geoDatum.getName();
        org.locationtech.proj4j.datum.Ellipsoid ellipsoid = CRSParser.convert(geoDatum.getEllipsoid());
        String code = name;
        if (geoDatum.hasIdentifiers()) {
            code = geoDatum.getIdentifier(0).getNameAndUniqueIdentifier();
        }
        return new Datum(code, transform, null, ellipsoid, name);
    }

    public static org.locationtech.proj4j.datum.Ellipsoid convert(Ellipsoid ellipsoid) {
        String name = ellipsoid.getName();
        org.locationtech.proj4j.datum.Ellipsoid converted = CRSParser.getEllipsoid(name);
        if (converted == null) {
            String shortName = name;
            if (ellipsoid.hasIdentifiers()) {
                shortName = ellipsoid.getIdentifier(0).getNameAndUniqueIdentifier();
            }
            double equatorRadius = CRSParser.convertValue(ellipsoid.getSemiMajorAxis(), ellipsoid.getUnit(), mil.nga.crs.common.Units.METRE);
            double poleRadius = 0.0;
            double reciprocalFlattening = 0.0;
            switch (ellipsoid.getType()) {
                case OBLATE: {
                    reciprocalFlattening = ellipsoid.getInverseFlattening();
                    if (reciprocalFlattening != 0.0) break;
                    reciprocalFlattening = Double.POSITIVE_INFINITY;
                    break;
                }
                case TRIAXIAL: {
                    TriaxialEllipsoid triaxial = (TriaxialEllipsoid)ellipsoid;
                    poleRadius = CRSParser.convertValue(triaxial.getSemiMinorAxis(), ellipsoid.getUnit(), mil.nga.crs.common.Units.METRE);
                    break;
                }
                default: {
                    throw new CRSException("Unsupported Ellipsoid Type: " + ellipsoid.getType());
                }
            }
            converted = new org.locationtech.proj4j.datum.Ellipsoid(shortName, equatorRadius, poleRadius, reciprocalFlattening, name);
        }
        return converted;
    }

    public static double[] convertDatumTransform(CRS crs) {
        double[] transform = null;
        Object toWGS84Object = crs.getExtra(CRSKeyword.TOWGS84.name());
        if (toWGS84Object != null) {
            String[] toWGS84 = (String[])toWGS84Object;
            transform = new double[toWGS84.length];
            for (int i = 0; i < toWGS84.length; ++i) {
                transform[i] = Double.valueOf(toWGS84[i]);
            }
        }
        return transform;
    }

    public static double[] convertDatumTransform(OperationMethod method) {
        double[] transform = null;
        if (method.hasParameters()) {
            double[] transform3 = new double[3];
            double[] transform7 = new double[7];
            boolean param3 = false;
            boolean param7 = false;
            for (OperationParameter parameter : method.getParameters()) {
                if (!parameter.hasParameter()) continue;
                switch (parameter.getParameter()) {
                    case X_AXIS_TRANSLATION: {
                        transform3[0] = CRSParser.getValue(parameter, mil.nga.crs.common.Units.METRE);
                        param3 = true;
                        break;
                    }
                    case Y_AXIS_TRANSLATION: {
                        transform3[1] = CRSParser.getValue(parameter, mil.nga.crs.common.Units.METRE);
                        param3 = true;
                        break;
                    }
                    case Z_AXIS_TRANSLATION: {
                        transform3[2] = CRSParser.getValue(parameter, mil.nga.crs.common.Units.METRE);
                        param3 = true;
                        break;
                    }
                    case X_AXIS_ROTATION: {
                        transform7[3] = CRSParser.getValue(parameter, mil.nga.crs.common.Units.ARC_SECOND);
                        param7 = true;
                        break;
                    }
                    case Y_AXIS_ROTATION: {
                        transform7[4] = CRSParser.getValue(parameter, mil.nga.crs.common.Units.ARC_SECOND);
                        param7 = true;
                        break;
                    }
                    case Z_AXIS_ROTATION: {
                        transform7[5] = CRSParser.getValue(parameter, mil.nga.crs.common.Units.ARC_SECOND);
                        param7 = true;
                        break;
                    }
                    case SCALE_DIFFERENCE: {
                        transform7[6] = CRSParser.getValue(parameter, mil.nga.crs.common.Units.PARTS_PER_MILLION);
                        param7 = true;
                        break;
                    }
                }
            }
            if (param7) {
                transform7[0] = transform3[0];
                transform7[1] = transform3[1];
                transform7[2] = transform3[2];
                transform = transform7;
            } else if (param3) {
                transform = transform3;
            }
        }
        return transform;
    }

    public static void updateProjection(Projection projection, org.locationtech.proj4j.datum.Ellipsoid ellipsoid, GeoDatum geoDatum) {
        projection.setEllipsoid(ellipsoid);
        if (geoDatum.hasPrimeMeridian()) {
            PrimeMeridian primeMeridian = geoDatum.getPrimeMeridian();
            String name = primeMeridian.getName();
            if (name != null) {
                name = name.toLowerCase();
            }
            projection.setPrimeMeridian(name);
            if (!projection.getPrimeMeridian().getName().equals(name)) {
                double primeMeridianLongitude = CRSParser.convertValue(primeMeridian.getLongitude(), primeMeridian.getLongitudeUnit(), mil.nga.crs.common.Units.DEGREE);
                projection.setPrimeMeridian(Double.toString(primeMeridianLongitude));
            }
        }
    }

    public static Projection createProjection(CoordinateSystem coordinateSystem) {
        Unit unit = coordinateSystem.getAxisUnit();
        String projectionName = null;
        projectionName = unit != null && (unit.getType() == UnitType.ANGLEUNIT || unit.getType() == UnitType.UNIT && unit.getName().toLowerCase().startsWith("deg")) ? "longlat" : "merc";
        return CRSParser.createProjection(projectionName, coordinateSystem);
    }

    public static Projection createProjection(CoordinateSystem coordinateSystem, MapProjection mapProjection) {
        Projection projection = null;
        OperationMethod method = mapProjection.getMethod();
        if (method.hasMethod()) {
            String projectionName = null;
            switch (method.getMethod()) {
                case ALBERS_EQUAL_AREA: {
                    projectionName = "aea";
                    break;
                }
                case AMERICAN_POLYCONIC: {
                    projectionName = "poly";
                    break;
                }
                case CASSINI_SOLDNER: {
                    projectionName = "cass";
                    break;
                }
                case EQUIDISTANT_CYLINDRICAL: {
                    projectionName = "eqc";
                    break;
                }
                case HOTINE_OBLIQUE_MERCATOR_A: {
                    projectionName = "omerc";
                    break;
                }
                case HOTINE_OBLIQUE_MERCATOR_B: {
                    if (mapProjection.getName().toLowerCase().contains("swiss oblique mercator") || method.getName().toLowerCase().contains("hotine_oblique_mercator_azimuth_center")) {
                        projectionName = "somerc";
                        break;
                    }
                    projectionName = "omerc";
                    break;
                }
                case KROVAK: {
                    projectionName = "krovak";
                    break;
                }
                case LAMBERT_AZIMUTHAL_EQUAL_AREA: {
                    projectionName = "laea";
                    break;
                }
                case LAMBERT_CONIC_CONFORMAL_1SP: 
                case LAMBERT_CONIC_CONFORMAL_2SP: {
                    projectionName = "lcc";
                    break;
                }
                case LAMBERT_CYLINDRICAL_EQUAL_AREA: {
                    projectionName = "cea";
                    break;
                }
                case MERCATOR_A: 
                case MERCATOR_B: {
                    projectionName = "merc";
                    break;
                }
                case NEW_ZEALAND_MAP_GRID: {
                    projectionName = "nzmg";
                    break;
                }
                case OBLIQUE_STEREOGRAPHIC: {
                    projectionName = "sterea";
                    break;
                }
                case POLAR_STEREOGRAPHIC_A: 
                case POLAR_STEREOGRAPHIC_B: 
                case POLAR_STEREOGRAPHIC_C: {
                    projectionName = "stere";
                    break;
                }
                case POPULAR_VISUALISATION_PSEUDO_MERCATOR: {
                    projectionName = "merc";
                    break;
                }
                case TRANSVERSE_MERCATOR: 
                case TRANSVERSE_MERCATOR_SOUTH_ORIENTATED: {
                    if (mapProjection.getName().toLowerCase().contains("utm zone")) {
                        projectionName = "utm";
                        break;
                    }
                    projectionName = "tmerc";
                    break;
                }
            }
            if (projectionName != null) {
                projection = CRSParser.createProjection(projectionName, coordinateSystem);
                switch (method.getMethod()) {
                    case HOTINE_OBLIQUE_MERCATOR_A: {
                        projection.setNoUoff(true);
                        break;
                    }
                }
            }
        }
        if (projection == null) {
            projection = CRSParser.createProjection(coordinateSystem);
        }
        return projection;
    }

    public static Projection createProjection(String projectionName, CoordinateSystem coordinateSystem) {
        Projection projection = CRSParser.getCRSFactory().getRegistry().getProjection(projectionName);
        String axisOrder = CRSParser.convert(coordinateSystem.getAxes());
        if (axisOrder.equals("wsu")) {
            projection.setAxisOrder(axisOrder);
        }
        return projection;
    }

    public static void updateUnits(Projection projection, CoordinateSystem coordinateSystem) {
        Unit unit;
        if (coordinateSystem.hasUnit() && ((unit = coordinateSystem.getUnit()).getType() == UnitType.LENGTHUNIT || unit.getType() == UnitType.UNIT)) {
            mil.nga.crs.common.Units type = mil.nga.crs.common.Units.fromUnit((Unit)unit);
            if (type != null) {
                switch (type) {
                    case MICROMETRE: 
                    case MILLIMETRE: 
                    case METRE: 
                    case KILOMETRE: {
                        projection.setUnits(Units.METRES);
                        break;
                    }
                    case US_SURVEY_FOOT: {
                        projection.setUnits(Units.US_FEET);
                        break;
                    }
                    case FOOT: {
                        projection.setUnits(Units.FEET);
                        break;
                    }
                }
            }
            if (unit.hasConversionFactor() && unit.getConversionFactor() != 1.0) {
                boolean fromMetres = false;
                switch (unit.getType()) {
                    case LENGTHUNIT: {
                        fromMetres = true;
                        break;
                    }
                    case UNIT: {
                        UnitType unitType = mil.nga.crs.common.Units.getUnitType((String)unit.getName());
                        fromMetres = unitType == null || unitType == UnitType.LENGTHUNIT;
                        break;
                    }
                }
                if (fromMetres) {
                    projection.setFromMetres(1.0 / unit.getConversionFactor());
                }
            }
        }
    }

    public static void updateParams(Projection projection, OperationMethod method, Unit unit) {
        if (method.hasParameters()) {
            for (OperationParameter parameter : method.getParameters()) {
                CRSParser.updateParams(projection, method, unit, parameter);
            }
        }
    }

    public static void updateParams(Projection projection, OperationMethod method, Unit unit, OperationParameter parameter) {
        if (parameter.hasParameter()) {
            block0 : switch (parameter.getParameter()) {
                case FALSE_EASTING: 
                case EASTING_AT_PROJECTION_CENTRE: 
                case EASTING_AT_FALSE_ORIGIN: {
                    projection.setFalseEasting(CRSParser.getValue(parameter, unit, projection.getUnits()));
                    break;
                }
                case FALSE_NORTHING: 
                case NORTHING_AT_PROJECTION_CENTRE: 
                case NORTHING_AT_FALSE_ORIGIN: {
                    projection.setFalseNorthing(CRSParser.getValue(parameter, unit, projection.getUnits()));
                    break;
                }
                case SCALE_FACTOR_AT_NATURAL_ORIGIN: 
                case SCALE_FACTOR_ON_INITIAL_LINE: 
                case SCALE_FACTOR_ON_PSEUDO_STANDARD_PARALLEL: {
                    projection.setScaleFactor(CRSParser.getValue(parameter, mil.nga.crs.common.Units.UNITY));
                    break;
                }
                case LATITUDE_OF_1ST_STANDARD_PARALLEL: {
                    if (method.hasMethod()) {
                        switch (method.getMethod()) {
                            case LAMBERT_CYLINDRICAL_EQUAL_AREA: {
                                projection.setTrueScaleLatitude(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                                break block0;
                            }
                        }
                        projection.setProjectionLatitude1(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                        break;
                    }
                    projection.setProjectionLatitude1(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                    break;
                }
                case LATITUDE_OF_2ND_STANDARD_PARALLEL: {
                    projection.setProjectionLatitude2(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                    break;
                }
                case LATITUDE_OF_PROJECTION_CENTRE: 
                case LATITUDE_OF_NATURAL_ORIGIN: 
                case LATITUDE_OF_FALSE_ORIGIN: {
                    if (method.hasMethod()) {
                        switch (method.getMethod()) {
                            case POLAR_STEREOGRAPHIC_A: 
                            case POLAR_STEREOGRAPHIC_B: 
                            case POLAR_STEREOGRAPHIC_C: {
                                projection.setTrueScaleLatitude(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                                if (projection.getTrueScaleLatitude() >= 0.0) {
                                    projection.setProjectionLatitudeDegrees(90.0);
                                    break block0;
                                }
                                projection.setProjectionLatitudeDegrees(-90.0);
                                break block0;
                            }
                            case EQUIDISTANT_CYLINDRICAL: {
                                projection.setTrueScaleLatitude(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                                projection.setProjectionLatitude(0.0);
                                break block0;
                            }
                            case LAMBERT_CYLINDRICAL_EQUAL_AREA: 
                            case MERCATOR_A: 
                            case MERCATOR_B: 
                            case POPULAR_VISUALISATION_PSEUDO_MERCATOR: {
                                projection.setTrueScaleLatitude(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                                break block0;
                            }
                            case LAMBERT_CONIC_CONFORMAL_1SP: 
                            case LAMBERT_CONIC_CONFORMAL_2SP: {
                                projection.setProjectionLatitude(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                                if (projection.getProjectionLatitude1() != 0.0) break block0;
                                projection.setProjectionLatitude1(projection.getProjectionLatitude());
                                break block0;
                            }
                        }
                        projection.setProjectionLatitude(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                        break;
                    }
                    projection.setProjectionLatitude(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                    break;
                }
                case LONGITUDE_OF_PROJECTION_CENTRE: 
                case LONGITUDE_OF_NATURAL_ORIGIN: 
                case LONGITUDE_OF_FALSE_ORIGIN: 
                case LONGITUDE_OF_ORIGIN: {
                    if (method.hasMethod()) {
                        switch (method.getMethod()) {
                            case HOTINE_OBLIQUE_MERCATOR_A: {
                                projection.setLonC(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                                break block0;
                            }
                            case HOTINE_OBLIQUE_MERCATOR_B: {
                                if (projection.getName() != null && projection.getName().equals("somerc")) {
                                    projection.setProjectionLongitude(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                                    break block0;
                                }
                                projection.setLonC(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                                break block0;
                            }
                        }
                        projection.setProjectionLongitude(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                        break;
                    }
                    projection.setProjectionLongitude(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                    break;
                }
                case AZIMUTH_OF_INITIAL_LINE: 
                case CO_LATITUDE_OF_CONE_AXIS: {
                    if (method.hasMethod()) {
                        switch (method.getMethod()) {
                            case HOTINE_OBLIQUE_MERCATOR_B: {
                                if (projection.getName() != null && projection.getName().equals("somerc")) break block0;
                                projection.setAlpha(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                                break block0;
                            }
                        }
                        projection.setAlpha(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                        break;
                    }
                    projection.setAlpha(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                    break;
                }
                case ANGLE_FROM_RECTIFIED_TO_SKEW_GRID: {
                    if (method.hasMethod()) {
                        switch (method.getMethod()) {
                            case HOTINE_OBLIQUE_MERCATOR_B: {
                                if (projection.getName() != null && projection.getName().equals("somerc")) break block0;
                                projection.setGamma(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                                break block0;
                            }
                        }
                        projection.setGamma(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                        break;
                    }
                    projection.setGamma(CRSParser.getValue(parameter, mil.nga.crs.common.Units.RADIAN));
                    break;
                }
            }
        }
    }

    public static String convert(List<Axis> axes) {
        String axisValue = null;
        int axesCount = axes.size();
        if (axesCount == 2 || axesCount == 3) {
            StringBuilder axisString = new StringBuilder();
            for (Axis axis : axes) {
                switch (axis.getDirection()) {
                    case EAST: {
                        axisString.append("e");
                        break;
                    }
                    case WEST: {
                        axisString.append("w");
                        break;
                    }
                    case NORTH: {
                        axisString.append("n");
                        break;
                    }
                    case SOUTH: {
                        axisString.append("s");
                        break;
                    }
                    case UP: {
                        axisString.append("u");
                        break;
                    }
                    case DOWN: {
                        axisString.append("d");
                        break;
                    }
                    default: {
                        axisString = null;
                    }
                }
                if (axisString != null) continue;
                break;
            }
            if (axisString != null) {
                if (axesCount == 2) {
                    axisString.append("u");
                }
                axisValue = axisString.toString();
            }
        }
        return axisValue;
    }

    public static double getValue(OperationParameter parameter, org.locationtech.proj4j.units.Unit unit) {
        return CRSParser.getValue(parameter, null, unit);
    }

    public static double getValue(OperationParameter parameter, Unit unit, org.locationtech.proj4j.units.Unit inUnit) {
        mil.nga.crs.common.Units desiredUnit = null;
        desiredUnit = inUnit instanceof DegreeUnit ? mil.nga.crs.common.Units.DEGREE : mil.nga.crs.common.Units.METRE;
        return CRSParser.getValue(parameter, unit, desiredUnit);
    }

    public static double getValue(OperationParameter parameter, mil.nga.crs.common.Units unit) {
        return CRSParser.getValue(parameter, null, unit);
    }

    public static double getValue(OperationParameter parameter, Unit unit, mil.nga.crs.common.Units inUnit) {
        return CRSParser.getValue(parameter, unit, inUnit.createUnit());
    }

    public static double getValue(OperationParameter parameter, Unit unit) {
        return CRSParser.getValue(parameter, null, unit);
    }

    public static double getValue(OperationParameter parameter, Unit unit, Unit inUnit) {
        Unit parameterUnit = parameter.getUnit();
        if (parameterUnit == null) {
            parameterUnit = unit;
        }
        return CRSParser.convertValue(parameter.getValue(), parameterUnit, inUnit);
    }

    public static double convertValue(double value, Unit fromUnit, mil.nga.crs.common.Units toUnit) {
        return CRSParser.convertValue(value, fromUnit, toUnit.createUnit());
    }

    public static double convertValue(double value, Unit fromUnit, Unit toUnit) {
        if (fromUnit == null) {
            fromUnit = mil.nga.crs.common.Units.createDefaultUnit((UnitType)toUnit.getType());
        }
        if (mil.nga.crs.common.Units.canConvert((Unit)fromUnit, (Unit)toUnit)) {
            value = mil.nga.crs.common.Units.convert((double)value, (Unit)fromUnit, (Unit)toUnit);
        }
        return value;
    }

    static {
        for (Datum datum : Registry.datums) {
            datums.put(datum.getCode().toLowerCase(), datum);
        }
        datums.remove(Datum.WGS84.getCode().toLowerCase());
        for (Datum datum : org.locationtech.proj4j.datum.Ellipsoid.ellipsoids) {
            ellipsoids.put(datum.getShortName().toLowerCase(), (org.locationtech.proj4j.datum.Ellipsoid)datum);
        }
        ellipsoids.remove(org.locationtech.proj4j.datum.Ellipsoid.SPHERE.getShortName().toLowerCase());
    }
}

