/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.proj;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProjectionRetriever {
    private static final Logger log = Logger.getLogger(ProjectionRetriever.class.getName());
    public static final String PROJECTIONS_PROPERTY_FILE_PREFIX = "projections";
    public static final String PROJECTIONS_PROPERTY_FILE_SUFFIX = "properties";
    private static final Map<String, Properties> properties = new HashMap<String, Properties>();

    public static String getProjection(long epsg) {
        return ProjectionRetriever.getProjection("EPSG", epsg);
    }

    public static String getProjection(String authority, long code) {
        return ProjectionRetriever.getProjection(authority, String.valueOf(code));
    }

    public static String getProjection(String authority, String code) {
        Properties authorityProperties = ProjectionRetriever.getOrCreateProjections(authority);
        String projection = authorityProperties.getProperty(code);
        return projection;
    }

    public static Properties getOrCreateProjections(String authority) {
        String authorityKey = authority.toLowerCase();
        Properties authorityProperties = properties.get(authorityKey);
        if (authorityProperties == null) {
            ProjectionRetriever.loadProperties(authorityKey);
            authorityProperties = properties.get(authorityKey);
        }
        return authorityProperties;
    }

    public static Properties getProjections(String authority) {
        return properties.get(authority.toLowerCase());
    }

    public static void clear() {
        properties.clear();
    }

    public static void clear(String authority) {
        properties.remove(authority.toLowerCase());
    }

    public static void clear(String authority, long code) {
        ProjectionRetriever.clear(authority, String.valueOf(code));
    }

    public static void clear(String authority, String code) {
        Properties properties = ProjectionRetriever.getProjections(authority);
        if (properties != null) {
            properties.remove(code);
        }
    }

    private static void loadProperties(String authority) {
        String authorityFile = ProjectionRetriever.propertyFileName(authority);
        InputStream in = ProjectionRetriever.class.getResourceAsStream("/" + authorityFile);
        ProjectionRetriever.setProjections(authority, in);
    }

    public static String propertyFileName(String authority) {
        return "projections." + authority.toLowerCase() + "." + PROJECTIONS_PROPERTY_FILE_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProjections(String authority, InputStream propertiesStream) {
        Properties authorityProperties = new Properties();
        if (propertiesStream != null) {
            try {
                authorityProperties.load(propertiesStream);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Failed to load authority: " + authority, e);
            }
            finally {
                try {
                    propertiesStream.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Failed to close authority: " + authority, e);
                }
            }
        } else {
            log.log(Level.WARNING, "Failed to load authority: " + authority);
        }
        ProjectionRetriever.setProjections(authority, authorityProperties);
    }

    public static void setProjections(String authority, Properties authorityProperties) {
        properties.put(authority.toLowerCase(), authorityProperties);
    }

    public static void setProjections(String authority, File propertiesFile) throws FileNotFoundException {
        FileInputStream intpuStream = new FileInputStream(propertiesFile);
        ProjectionRetriever.setProjections(authority, intpuStream);
    }

    public static void setProjection(String authority, long code, String projection) {
        ProjectionRetriever.setProjection(authority, String.valueOf(code), projection);
    }

    public static void setProjection(String authority, String code, String projection) {
        Properties authorityProperties = ProjectionRetriever.getOrCreateProjections(authority);
        authorityProperties.setProperty(code, projection);
    }
}

