/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.proj;

import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;
import org.locationtech.proj4j.ProjCoordinate;

public class ProjectionTransform {
    protected static CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
    protected final Projection fromProjection;
    protected final Projection toProjection;
    protected final CoordinateTransform transform;

    public static ProjectionTransform create(Projection fromProjection, Projection toProjection) {
        return new ProjectionTransform(fromProjection, toProjection);
    }

    public static ProjectionTransform create(Projection fromProjection, long toEpsg) {
        return new ProjectionTransform(fromProjection, ProjectionFactory.getProjection(toEpsg));
    }

    public static ProjectionTransform create(Projection fromProjection, String toAuthority, long toCode) {
        return new ProjectionTransform(fromProjection, ProjectionFactory.getProjection(toAuthority, toCode));
    }

    public static ProjectionTransform create(Projection fromProjection, String toAuthority, String toCode) {
        return new ProjectionTransform(fromProjection, ProjectionFactory.getProjection(toAuthority, toCode));
    }

    public static ProjectionTransform create(long fromEpsg, Projection toProjection) {
        return new ProjectionTransform(ProjectionFactory.getProjection(fromEpsg), toProjection);
    }

    public static ProjectionTransform create(String fromAuthority, long fromCode, Projection toProjection) {
        return new ProjectionTransform(ProjectionFactory.getProjection(fromAuthority, fromCode), toProjection);
    }

    public static ProjectionTransform create(String fromAuthority, String fromCode, Projection toProjection) {
        return new ProjectionTransform(ProjectionFactory.getProjection(fromAuthority, fromCode), toProjection);
    }

    public static ProjectionTransform create(long fromEpsg, long toEpsg) {
        return new ProjectionTransform(ProjectionFactory.getProjection(fromEpsg), ProjectionFactory.getProjection(toEpsg));
    }

    public static ProjectionTransform create(String fromAuthority, long fromCode, String toAuthority, long toCode) {
        return new ProjectionTransform(ProjectionFactory.getProjection(fromAuthority, fromCode), ProjectionFactory.getProjection(toAuthority, toCode));
    }

    public static ProjectionTransform create(String fromAuthority, String fromCode, String toAuthority, String toCode) {
        return new ProjectionTransform(ProjectionFactory.getProjection(fromAuthority, fromCode), ProjectionFactory.getProjection(toAuthority, toCode));
    }

    public static ProjectionTransform create(ProjectionTransform transform) {
        return new ProjectionTransform(transform);
    }

    public ProjectionTransform(Projection fromProjection, Projection toProjection) {
        this.fromProjection = fromProjection;
        this.toProjection = toProjection;
        this.transform = ctFactory.createTransform(fromProjection.getCrs(), toProjection.getCrs());
    }

    public ProjectionTransform(ProjectionTransform transform) {
        this(transform.getFromProjection(), transform.getToProjection());
    }

    public ProjCoordinate transform(ProjCoordinate from) {
        ProjCoordinate to = new ProjCoordinate();
        this.transform.transform(from, to);
        return to;
    }

    public double[] transform(double x, double y) {
        ProjCoordinate fromCoord = new ProjCoordinate(x, y);
        ProjCoordinate toCoord = this.transform(fromCoord);
        return new double[]{toCoord.x, toCoord.y};
    }

    public double[] transform(double minX, double minY, double maxX, double maxY) {
        ProjCoordinate lowerLeft = new ProjCoordinate(minX, minY);
        ProjCoordinate lowerRight = new ProjCoordinate(maxX, minY);
        ProjCoordinate upperRight = new ProjCoordinate(maxX, maxY);
        ProjCoordinate upperLeft = new ProjCoordinate(minX, maxY);
        ProjCoordinate projectedLowerLeft = this.transform(lowerLeft);
        ProjCoordinate projectedLowerRight = this.transform(lowerRight);
        ProjCoordinate projectedUpperRight = this.transform(upperRight);
        ProjCoordinate projectedUpperLeft = this.transform(upperLeft);
        double[] bounds = new double[]{Math.min(projectedLowerLeft.x, projectedUpperLeft.x), Math.min(projectedLowerLeft.y, projectedLowerRight.y), Math.max(projectedLowerRight.x, projectedUpperRight.x), Math.max(projectedUpperLeft.y, projectedUpperRight.y)};
        return bounds;
    }

    public Projection getFromProjection() {
        return this.fromProjection;
    }

    public Projection getToProjection() {
        return this.toProjection;
    }

    public CoordinateTransform getTransform() {
        return this.transform;
    }

    public boolean isSameProjection() {
        return this.fromProjection.equals(this.toProjection);
    }

    public ProjectionTransform getInverseTransformation() {
        return this.toProjection.getTransformation(this.fromProjection);
    }
}

