/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import mx4j.remote.ConnectionNotificationEmitter;

public abstract class AbstractJMXConnector
implements JMXConnector,
Serializable {
    private final JMXServiceURL address;
    private transient boolean connected;
    private transient boolean closed;
    private transient ConnectionNotificationEmitter emitter;

    protected AbstractJMXConnector(JMXServiceURL address) throws IOException {
        if (address == null) {
            throw new IOException("JMXServiceURL cannot be null");
        }
        this.address = address;
    }

    protected JMXServiceURL getAddress() {
        return this.address;
    }

    public void connect() throws IOException, SecurityException {
        this.connect((Map)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map environment) throws IOException, SecurityException {
        AbstractJMXConnector abstractJMXConnector = this;
        synchronized (abstractJMXConnector) {
            if (this.isConnected()) {
                return;
            }
            if (this.isClosed()) {
                throw new IOException("This connector has already been closed");
            }
            this.doConnect(environment);
            this.connected = true;
        }
        this.sendConnectionNotificationOpened();
    }

    protected abstract void doConnect(Map var1) throws IOException, SecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        AbstractJMXConnector abstractJMXConnector = this;
        synchronized (abstractJMXConnector) {
            if (this.isClosed()) {
                return;
            }
            this.closed = true;
            this.connected = false;
            this.doClose();
        }
        this.sendConnectionNotificationClosed();
    }

    protected abstract void doClose() throws IOException;

    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.getMBeanServerConnection(null);
    }

    public MBeanServerConnection getMBeanServerConnection(Subject delegate) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Connection has not been established");
        }
        return this.doGetMBeanServerConnection(delegate);
    }

    protected abstract MBeanServerConnection doGetMBeanServerConnection(Subject var1) throws IOException;

    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.getConnectionNotificationEmitter().addNotificationListener(listener, filter, handback);
    }

    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.getConnectionNotificationEmitter().removeNotificationListener(listener);
    }

    public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.getConnectionNotificationEmitter().removeNotificationListener(listener, filter, handback);
    }

    private void sendConnectionNotificationOpened() {
        this.getConnectionNotificationEmitter().sendConnectionNotificationOpened();
    }

    protected void sendConnectionNotificationClosed() {
        this.getConnectionNotificationEmitter().sendConnectionNotificationClosed();
    }

    protected ConnectionNotificationEmitter createConnectionNotificationEmitter() {
        return new ConnectionNotificationEmitter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionNotificationEmitter getConnectionNotificationEmitter() {
        AbstractJMXConnector abstractJMXConnector = this;
        synchronized (abstractJMXConnector) {
            if (this.emitter == null) {
                this.emitter = this.createConnectionNotificationEmitter();
            }
        }
        return this.emitter;
    }

    protected synchronized boolean isConnected() {
        return this.connected;
    }

    protected synchronized boolean isClosed() {
        return this.closed;
    }
}

