/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreSerIdObjectInputStream
extends ObjectInputStream {
    private static final Logger log = LoggerFactory.getLogger(IgnoreSerIdObjectInputStream.class);

    public IgnoreSerIdObjectInputStream(byte[] bytes) throws IOException {
        this(new ByteArrayInputStream(bytes));
    }

    public IgnoreSerIdObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        Class<?> localClass;
        ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
        try {
            localClass = Class.forName(resultClassDescriptor.getName());
        }
        catch (ClassNotFoundException e) {
            log.warn("No local class for " + resultClassDescriptor.getName());
            return resultClassDescriptor;
        }
        ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
        if (localClassDescriptor != null) {
            long localSerId = localClassDescriptor.getSerialVersionUID();
            long streamSerId = resultClassDescriptor.getSerialVersionUID();
            if (streamSerId != localSerId) {
                log.warn("Overriding serialized class {} version mismatch: local serialVersionUID = {} stream serialVersionUID = {}", new Object[]{localClass, localSerId, streamSerId});
                resultClassDescriptor = localClassDescriptor;
            }
        }
        return resultClassDescriptor;
    }
}

