/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.util;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.BadSqlGrammarException;

public class SqlInjectionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SqlInjectionUtil.class);
    private static final String REG = "\\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|;|\\+|'|%)\n";
    private static final Pattern sqlPattern = Pattern.compile("\\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|;|\\+|'|%)\n", 2);

    public static void filterContent(String ... values) {
        for (String value : values) {
            if (value == null || "".equals(value) || SqlInjectionUtil.isSqlValid(value)) continue;
            LOG.info("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669: {}", (Object)value);
            throw new BadSqlGrammarException("", "bad sql" + value, new SQLException("\u5f53\u524d\u64cd\u4f5c\u5b58\u5728SQL\u975e\u6cd5\u6ce8\u5165"));
        }
    }

    public static void filterContent(Map<String, String> fields) {
        Iterator<String> iterator = fields.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            String value = fields.get(key);
            SqlInjectionUtil.filterContent(key);
            SqlInjectionUtil.filterContent(value);
        }
    }

    public static boolean isSqlValid(String str) {
        Matcher matcher = sqlPattern.matcher(str);
        if (matcher.find() && StringUtils.isNotBlank((CharSequence)matcher.group())) {
            LOG.info("\u53c2\u6570\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff0c\u8bf7\u786e\u8ba4\uff1a" + matcher.group());
            return false;
        }
        return true;
    }
}

