/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;

public enum BackgroundResourceReleaser {

    public static final String BACKGROUND_RESOURCE_RELEASER = "background~resource~releaser";
    static final boolean BG_RELEASER = Jvm.getBoolean("background.releaser", true);
    private static final BlockingQueue<Object> RESOURCES = new ArrayBlockingQueue<Object>(128);
    private static final AtomicLong COUNTER = new AtomicLong();
    private static final Thread RELEASER = new Thread(BackgroundResourceReleaser::runReleaseResources, "background~resource~releaser");

    private static void runReleaseResources() {
        try {
            while (true) {
                Object o = RESOURCES.take();
                BackgroundResourceReleaser.performRelease(o);
            }
        }
        catch (InterruptedException e) {
            Jvm.warn().on(BackgroundResourceReleaser.class, "Died on interrupt");
            return;
        }
    }

    public static void release(AbstractCloseable closeable) {
        BackgroundResourceReleaser.release0(closeable);
    }

    public static void release(AbstractReferenceCounted referenceCounted) {
        BackgroundResourceReleaser.release0(referenceCounted);
    }

    public static void run(Runnable runnable) {
        BackgroundResourceReleaser.release0(runnable);
    }

    private static void release0(Object o) {
        COUNTER.incrementAndGet();
        if (RESOURCES.offer(o)) {
            return;
        }
        BackgroundResourceReleaser.performRelease(o);
    }

    public static void releasePendingResources() {
        try {
            Object o;
            while ((o = RESOURCES.poll(1L, TimeUnit.MILLISECONDS)) != null) {
                BackgroundResourceReleaser.performRelease(o);
            }
            for (int i = 0; i < 1000 && COUNTER.get() > 0L; ++i) {
                Jvm.pause(1L);
            }
            long left = COUNTER.get();
            if (left != 0L) {
                Jvm.warn().on(BackgroundResourceReleaser.class, "Still got " + left + " resources to clean");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static void performRelease(Object o) {
        try {
            if (o instanceof AbstractCloseable) {
                ((AbstractCloseable)o).callPerformClose();
            } else if (o instanceof AbstractReferenceCounted) {
                ((AbstractReferenceCounted)o).performRelease();
            } else if (o instanceof Runnable) {
                ((Runnable)o).run();
            } else {
                Jvm.warn().on(BackgroundResourceReleaser.class, "Don't know how to release a " + o.getClass());
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(BackgroundResourceReleaser.class, "Failed in release/close", e);
        }
        finally {
            COUNTER.decrementAndGet();
        }
    }

    static {
        RELEASER.setDaemon(true);
        RELEASER.start();
    }
}

