/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.java.JavaPlatform;

public final class Version {
    private static final int[] STRUCTURED_VERSION = new int[]{9, 9, 1, 8};
    private static final String VERSION = "9.9.1.8";
    private static final String BUILD = "030415";
    private static final String RELEASE_DATE = "2020-10-22";
    private static final String MAJOR_RELEASE_DATE = "2018-09-27";
    public static Class<? extends Configuration> configurationClass;
    public static String softwareEdition;
    public static Platform platform;

    private Version() {
    }

    public static String getProductName() {
        return "SAXON";
    }

    public static String getProductVendor() {
        return "Saxonica";
    }

    public static String getProductVariantAndVersion(String edition) {
        return edition + " " + Version.getProductVersion();
    }

    public static String getProductVersion() {
        return VERSION;
    }

    public static int[] getStructuredVersionNumber() {
        return STRUCTURED_VERSION;
    }

    public static String getReleaseDate() {
        return RELEASE_DATE;
    }

    public static String getMajorReleaseDate() {
        return MAJOR_RELEASE_DATE;
    }

    public static String getProductTitle() {
        return Version.getProductName() + '-' + softwareEdition + ' ' + Version.getProductVersion() + (platform.isJava() ? (char)'J' : 'N') + " from Saxonica";
    }

    public static String getWebSiteAddress() {
        return "http://www.saxonica.com/";
    }

    public static void main(String[] args) {
        System.err.println(Version.getProductTitle() + " (build " + BUILD + ')');
    }

    static {
        softwareEdition = "HE";
        platform = new JavaPlatform();
    }
}

