/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import org.apache.commons.lang3.StringUtils;

public class ASTLiteral
extends AbstractJavaTypeNode {
    private static final String TEXTBLOCK_DELIMITER = "\"\"\"";
    private boolean isInt;
    private boolean isFloat;
    private boolean isChar;
    private boolean isString;
    private static final Pattern SINGLE_CHAR_ESCAPE_PATTERN = Pattern.compile("^\"\\\\(([ntbrf\\\\'\\\"])|([0-7][0-7]?)|([0-3][0-7][0-7]))\"");

    @Deprecated
    @InternalApi
    public ASTLiteral(int id) {
        super(id);
    }

    @Deprecated
    @InternalApi
    public ASTLiteral(JavaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Deprecated
    @InternalApi
    public void setIntLiteral() {
        this.isInt = true;
    }

    public boolean isIntLiteral() {
        String image = this.getImage();
        return this.isInt && image != null && image.length() > 0 && !image.endsWith("l") && !image.endsWith("L");
    }

    public boolean isLongLiteral() {
        String image = this.getImage();
        return this.isInt && image != null && image.length() > 0 && (image.endsWith("l") || image.endsWith("L"));
    }

    @Deprecated
    @InternalApi
    public void setFloatLiteral() {
        this.isFloat = true;
    }

    public boolean isFloatLiteral() {
        char lastChar;
        String image = this.getImage();
        return this.isFloat && image != null && image.length() > 0 && ((lastChar = image.charAt(image.length() - 1)) == 'f' || lastChar == 'F');
    }

    public boolean isDoubleLiteral() {
        char lastChar;
        String image = this.getImage();
        return this.isFloat && image != null && image.length() > 0 && ((lastChar = image.charAt(image.length() - 1)) == 'd' || lastChar == 'D' || Character.isDigit(lastChar) || lastChar == '.');
    }

    private String stripIntValue() {
        String image = this.getImage().toLowerCase(Locale.ROOT).replaceAll("_", "");
        boolean isNegative = false;
        if (image.charAt(0) == '-') {
            isNegative = true;
            image = image.substring(1);
        }
        if (image.endsWith("l")) {
            image = image.substring(0, image.length() - 1);
        }
        if (image.charAt(0) == '0' && image.length() > 1) {
            image = image.charAt(1) == 'x' || image.charAt(1) == 'b' ? image.substring(2) : image.substring(1);
        }
        if (isNegative) {
            return "-" + image;
        }
        return image;
    }

    private String stripFloatValue() {
        return this.getImage().toLowerCase(Locale.ROOT).replaceAll("_", "");
    }

    private int getIntBase() {
        int offset;
        String image = this.getImage().toLowerCase(Locale.ROOT);
        int n = offset = image.charAt(0) == '-' ? 1 : 0;
        if (image.startsWith("0x", offset)) {
            return 16;
        }
        if (image.startsWith("0b", offset)) {
            return 2;
        }
        if (image.startsWith("0", offset) && image.length() > 1) {
            return 8;
        }
        return 10;
    }

    public int getValueAsInt() {
        if (this.isInt) {
            return (int)this.getValueAsLong();
        }
        return 0;
    }

    public long getValueAsLong() {
        if (this.isInt) {
            BigInteger bigInt = new BigInteger(this.stripIntValue(), this.getIntBase());
            return bigInt.longValue();
        }
        return 0L;
    }

    public float getValueAsFloat() {
        if (this.isFloat) {
            return Float.parseFloat(this.stripFloatValue());
        }
        return Float.NaN;
    }

    public double getValueAsDouble() {
        if (this.isFloat) {
            return Double.parseDouble(this.stripFloatValue());
        }
        return Double.NaN;
    }

    @Deprecated
    @InternalApi
    public void setCharLiteral() {
        this.isChar = true;
    }

    public boolean isCharLiteral() {
        return this.isChar;
    }

    @Deprecated
    @InternalApi
    public void setStringLiteral() {
        this.isString = true;
    }

    public boolean isStringLiteral() {
        return this.isString;
    }

    public String getEscapedStringLiteral() {
        String image = this.getImage();
        if (!this.isStringLiteral() && !this.isCharLiteral()) {
            return image;
        }
        int fullLength = this.getEndColumn() - this.getBeginColumn();
        if (fullLength > image.length()) {
            StringBuilder result = new StringBuilder(fullLength);
            for (int i = 0; i < image.length(); ++i) {
                char c = image.charAt(i);
                if (c < ' ' || c > '\u00ff' || image.length() == 1) {
                    String hex = "0000" + Integer.toHexString(c);
                    result.append("\\u").append(hex.substring(hex.length() - 4));
                    continue;
                }
                result.append(c);
            }
            return result.toString();
        }
        return image;
    }

    public boolean isSingleCharacterStringLiteral() {
        if (this.isString) {
            String image = this.getImage();
            int length = image.length();
            if (length == 3) {
                return true;
            }
            if (image.charAt(1) == '\\') {
                return SINGLE_CHAR_ESCAPE_PATTERN.matcher(image).matches();
            }
        }
        return false;
    }

    public boolean isTextBlock() {
        return this.isString && this.getImage().startsWith(TEXTBLOCK_DELIMITER);
    }

    public String getTextBlockContent() {
        if (!this.isTextBlock()) {
            return this.getImage();
        }
        return ASTLiteral.determineTextBlockContent(this.getImage());
    }

    static String determineTextBlockContent(String image) {
        String content = image.replaceAll("\r\n|\r", "\n");
        int start = ASTLiteral.determineContentStart(content);
        content = content.substring(start, content.length() - TEXTBLOCK_DELIMITER.length());
        int prefixLength = Integer.MAX_VALUE;
        List<String> lines = Arrays.asList(content.split("\\n"));
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{line}) && i != lines.size() - 1) continue;
            prefixLength = Math.min(prefixLength, ASTLiteral.countLeadingWhitespace(line));
        }
        if (prefixLength == Integer.MAX_VALUE) {
            prefixLength = 0;
        }
        StringBuilder sb = new StringBuilder(content.length());
        for (int i = 0; i < lines.size(); ++i) {
            boolean isFirstLine;
            String line = lines.get(i);
            if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{line}) && line.length() >= prefixLength) {
                line = line.substring(prefixLength);
            }
            line = ASTLiteral.removeTrailingWhitespace(line);
            sb.append(line);
            boolean isLastLine = i == lines.size() - 1;
            boolean bl = isFirstLine = i == 0;
            if (isLastLine && (isFirstLine || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{line}))) continue;
            sb.append('\n');
        }
        ASTLiteral.interpretEscapeSequences(sb);
        return sb.toString();
    }

    private static void interpretEscapeSequences(StringBuilder sb) {
        block12: for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c != '\\' || i >= sb.length() - 1) continue;
            char cnext = sb.charAt(i + 1);
            switch (cnext) {
                case '\n': {
                    sb.delete(i, i + 2);
                    continue block12;
                }
                case '\\': {
                    sb.deleteCharAt(i);
                    continue block12;
                }
                case 'n': {
                    sb.deleteCharAt(i);
                    sb.setCharAt(i, '\n');
                    continue block12;
                }
                case 't': {
                    sb.deleteCharAt(i);
                    sb.setCharAt(i, '\t');
                    continue block12;
                }
                case 'b': {
                    sb.deleteCharAt(i);
                    sb.setCharAt(i, '\b');
                    continue block12;
                }
                case 'r': {
                    sb.deleteCharAt(i);
                    sb.setCharAt(i, '\r');
                    continue block12;
                }
                case 'f': {
                    sb.deleteCharAt(i);
                    sb.setCharAt(i, '\f');
                    continue block12;
                }
                case 's': {
                    sb.deleteCharAt(i);
                    sb.setCharAt(i, ' ');
                    continue block12;
                }
                case '\"': {
                    sb.deleteCharAt(i);
                    sb.setCharAt(i, '\"');
                    continue block12;
                }
                case '\'': {
                    sb.deleteCharAt(i);
                    sb.setCharAt(i, '\'');
                    continue block12;
                }
            }
        }
    }

    private static int determineContentStart(String s) {
        int start;
        for (start = TEXTBLOCK_DELIMITER.length(); start < s.length() && Character.isWhitespace(s.charAt(start)); ++start) {
            if (s.charAt(start) != '\n') continue;
            return start + 1;
        }
        return start;
    }

    private static int countLeadingWhitespace(String s) {
        int count;
        for (count = 0; count < s.length() && Character.isWhitespace(s.charAt(count)); ++count) {
        }
        return count;
    }

    private static String removeTrailingWhitespace(String s) {
        int endIndexIncluding;
        for (endIndexIncluding = s.length() - 1; endIndexIncluding >= 0 && Character.isWhitespace(s.charAt(endIndexIncluding)); --endIndexIncluding) {
        }
        return s.substring(0, endIndexIncluding + 1);
    }
}

