/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class GuardLogStatementRule
extends AbstractJavaRule
implements Rule {
    private static final PropertyDescriptor<List<String>> LOG_LEVELS = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"logLevels").desc("LogLevels to guard")).defaultValues((Object)"trace", (Object[])new String[]{"debug", "info", "warn", "error", "log", "finest", "finer", "fine", "info", "warning", "severe"}).delim(',').build();
    private static final PropertyDescriptor<List<String>> GUARD_METHODS = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"guardsMethods").desc("Method use to guard the log statement")).defaultValues((Object)"isTraceEnabled", (Object[])new String[]{"isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled", "isLoggable"}).delim(',').build();
    private Map<String, String> guardStmtByLogLevel = new HashMap<String, String>(12);
    private static final String JAVA_UTIL_LOG_METHOD = "log";
    private static final String JAVA_UTIL_LOG_GUARD_METHOD = "isLoggable";

    public GuardLogStatementRule() {
        this.definePropertyDescriptor(LOG_LEVELS);
        this.definePropertyDescriptor(GUARD_METHODS);
    }

    @Override
    public Object visit(ASTCompilationUnit unit, Object data) {
        this.extractProperties();
        return super.visit(unit, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTStatementExpression node, Object data) {
        if (node.getNumChildren() < 1 || !(node.getChild(0) instanceof ASTPrimaryExpression)) {
            return node;
        }
        ASTPrimaryExpression primary = (ASTPrimaryExpression)node.getChild(0);
        if (primary.getNumChildren() >= 2 && primary.getChild(0) instanceof ASTPrimaryPrefix) {
            ASTPrimarySuffix primarySuffix;
            ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)primary.getChild(0);
            String methodCall = this.getMethodCallName(prefix);
            String logLevel = this.getLogLevelName((Node)primary, methodCall);
            if (this.guardStmtByLogLevel.containsKey(methodCall) && logLevel != null && primary.getChild(1) instanceof ASTPrimarySuffix && !this.hasGuard(primary, methodCall, logLevel) && (this.hasStringConcatenationWithVars(primarySuffix = (ASTPrimarySuffix)primary.getChild(1)) || this.hasArgumentWithMethodCall(primarySuffix))) {
                this.addViolation(data, (Node)node);
            }
        }
        return super.visit(node, data);
    }

    private boolean hasStringConcatenationWithVars(ASTPrimarySuffix node) {
        if (!node.isArguments() || node.getArgumentCount() == 0) {
            return false;
        }
        ASTArgumentList argumentList = (ASTArgumentList)((ASTArguments)node.getFirstChildOfType(ASTArguments.class)).getFirstChildOfType(ASTArgumentList.class);
        for (JavaNode child : argumentList.children()) {
            if (!child.hasDescendantOfType(ASTAdditiveExpression.class) || !(child instanceof TypeNode) || !TypeTestUtil.isA(String.class, (TypeNode)child)) continue;
            return !this.isConstantStringExpression(child);
        }
        return this.isSingleAdditiveExpression(argumentList);
    }

    private boolean isSingleAdditiveExpression(ASTArgumentList argumentList) {
        return argumentList.size() == 1 && ((JavaNode)argumentList.getChild(0)).getNumChildren() == 1 && ((JavaNode)argumentList.getChild(0)).getChild(0) instanceof ASTAdditiveExpression;
    }

    private boolean isConstantStringExpression(JavaNode expr) {
        if (expr instanceof ASTPrimaryExpression && expr.getChild(0) instanceof ASTPrimaryPrefix && expr.getChild(0).getNumChildren() == 1 && expr.getChild(0).getChild(0) instanceof ASTLiteral) {
            return ((ASTLiteral)expr.getChild(0).getChild(0)).isStringLiteral();
        }
        if (expr instanceof ASTPrimaryExpression && expr.getChild(0) instanceof ASTPrimaryPrefix && expr.getChild(0).getNumChildren() == 1 && expr.getChild(0).getChild(0) instanceof ASTName) {
            ASTName name = (ASTName)expr.getChild(0).getChild(0);
            if (!TypeTestUtil.isA(String.class, (TypeNode)name)) {
                return false;
            }
            NameDeclaration nameDeclaration = name.getNameDeclaration();
            if (nameDeclaration instanceof VariableNameDeclaration) {
                ASTVariableDeclaratorId varId = ((VariableNameDeclaration)nameDeclaration).getDeclaratorId();
                if (!varId.isFinal()) {
                    return false;
                }
                if (varId.getParent() instanceof ASTVariableDeclarator) {
                    ASTVariableInitializer initializer = ((ASTVariableDeclarator)varId.getParent()).getInitializer();
                    if (initializer == null) {
                        return false;
                    }
                    return this.isConstantStringExpression((JavaNode)initializer.getFirstChildOfType(ASTExpression.class));
                }
            }
        }
        if (expr instanceof ASTExpression || expr instanceof ASTAdditiveExpression) {
            for (JavaNode javaNode : expr.children()) {
                if (this.isConstantStringExpression(javaNode)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasArgumentWithMethodCall(ASTPrimarySuffix node) {
        if (!node.isArguments() || node.getArgumentCount() <= 0) {
            return false;
        }
        ASTArgumentList arguments = (ASTArgumentList)node.getFirstDescendantOfType(ASTArgumentList.class);
        for (int i = 0; i < arguments.getNumChildren(); ++i) {
            JavaNode lastChild;
            JavaNode primaryExpr;
            JavaNode expression = (JavaNode)arguments.getChild(i);
            if (expression.getNumChildren() <= 0 || !((primaryExpr = expression.getChild(0)) instanceof ASTPrimaryExpression) || primaryExpr.getNumChildren() <= 1 || !((lastChild = primaryExpr.getChild(primaryExpr.getNumChildren() - 1)) instanceof ASTPrimarySuffix)) continue;
            return ((ASTPrimarySuffix)lastChild).isArguments();
        }
        return false;
    }

    private boolean hasGuard(ASTPrimaryExpression node, String methodCall, String logLevel) {
        ASTIfStatement ifStatement = (ASTIfStatement)node.getFirstParentOfType(ASTIfStatement.class);
        if (ifStatement == null) {
            return false;
        }
        ASTExpression expr = (ASTExpression)ifStatement.getFirstChildOfType(ASTExpression.class);
        List guardCalls = expr.findDescendantsOfType(ASTPrimaryPrefix.class);
        if (guardCalls.isEmpty()) {
            return false;
        }
        boolean foundGuard = false;
        for (ASTPrimaryPrefix guardCall : guardCalls) {
            if (guardCall.getNumChildren() < 1 || ((JavaNode)guardCall.getChild(0)).getImage() == null) continue;
            String guardMethodCall = this.getLastPartOfName(guardCall.getChild(0));
            boolean guardMethodCallMatches = this.guardStmtByLogLevel.get(methodCall).contains(guardMethodCall);
            boolean hasArguments = ((JavaNode)guardCall.getParent()).hasDescendantOfType(ASTArgumentList.class);
            if (guardMethodCallMatches && !JAVA_UTIL_LOG_GUARD_METHOD.equals(guardMethodCall)) {
                foundGuard = true;
            } else if (guardMethodCallMatches && hasArguments) {
                String guardArgLogLevel = this.getLogLevelName(guardCall.getParent(), guardMethodCall);
                foundGuard = logLevel.equals(guardArgLogLevel);
            }
            if (!foundGuard) continue;
            break;
        }
        return foundGuard;
    }

    private String getMethodCallName(ASTPrimaryPrefix prefix) {
        String result = "";
        if (prefix.getNumChildren() == 1 && prefix.getChild(0) instanceof ASTName) {
            result = this.getLastPartOfName(prefix.getChild(0));
        }
        return result;
    }

    private String getLastPartOfName(Node name) {
        int dotIndex;
        String result = "";
        if (name != null) {
            result = name.getImage();
        }
        if ((dotIndex = result.lastIndexOf(46)) > -1 && result.length() > dotIndex + 1) {
            result = result.substring(dotIndex + 1);
        }
        return result;
    }

    @SafeVarargs
    private static <N extends Node> N getFirstChild(Node root, Class<? extends Node> ... childrenTypes) {
        Node current = root;
        for (Class<? extends Node> clazz : childrenTypes) {
            Node child = (Node)current.getFirstChildOfType(clazz);
            if (child == null) {
                return null;
            }
            current = child;
        }
        Node result = current;
        return (N)result;
    }

    private String getLogLevelName(Node node, String methodCallName) {
        ASTArgumentList argumentList;
        if (!JAVA_UTIL_LOG_METHOD.equals(methodCallName) && !JAVA_UTIL_LOG_GUARD_METHOD.equals(methodCallName)) {
            return methodCallName;
        }
        String logLevel = null;
        ASTPrimarySuffix suffix = (ASTPrimarySuffix)node.getFirstDescendantOfType(ASTPrimarySuffix.class);
        if (suffix != null && (argumentList = (ASTArgumentList)suffix.getFirstDescendantOfType(ASTArgumentList.class)) != null && argumentList.getNumChildren() > 0) {
            ASTName name = (ASTName)GuardLogStatementRule.getFirstChild(argumentList.getChild(0), ASTPrimaryExpression.class, ASTPrimaryPrefix.class, ASTName.class);
            String lastPart = this.getLastPartOfName((Node)name);
            if (!(lastPart = lastPart.toLowerCase(Locale.ROOT)).isEmpty()) {
                logLevel = lastPart;
            }
        }
        return logLevel;
    }

    private void extractProperties() {
        if (this.guardStmtByLogLevel.isEmpty()) {
            ArrayList<String> logLevels = new ArrayList<String>((Collection)super.getProperty(LOG_LEVELS));
            ArrayList<String> guardMethods = new ArrayList<String>((Collection)super.getProperty(GUARD_METHODS));
            if (guardMethods.isEmpty() && !logLevels.isEmpty()) {
                throw new IllegalArgumentException("Can't specify logLevels without specifying guardMethods.");
            }
            if (logLevels.size() > guardMethods.size()) {
                int needed = logLevels.size() - guardMethods.size();
                String lastGuard = (String)guardMethods.get(guardMethods.size() - 1);
                for (int i = 0; i < needed; ++i) {
                    guardMethods.add(lastGuard);
                }
            }
            if (logLevels.size() != guardMethods.size()) {
                throw new IllegalArgumentException("For each logLevel a guardMethod must be specified.");
            }
            this.buildGuardStatementMap(logLevels, guardMethods);
        }
    }

    private void buildGuardStatementMap(List<String> logLevels, List<String> guardMethods) {
        for (int i = 0; i < logLevels.size(); ++i) {
            String logLevel = logLevels.get(i);
            if (this.guardStmtByLogLevel.containsKey(logLevel)) {
                String combinedGuard = this.guardStmtByLogLevel.get(logLevel);
                combinedGuard = combinedGuard + "|" + guardMethods.get(i);
                this.guardStmtByLogLevel.put(logLevel, combinedGuard);
                continue;
            }
            this.guardStmtByLogLevel.put(logLevel, guardMethods.get(i));
        }
    }
}

