/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.regex.RegexHelper;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.StringMultiProperty;
import net.sourceforge.pmd.properties.StringProperty;

public class GenericClassCounterRule
extends AbstractJavaRule {
    private static final StringMultiProperty NAME_MATCH_DESCRIPTOR = new StringMultiProperty("nameMatch", "A series of regex, separated by ',' to match on the classname", new String[]{""}, 1.0f, ',');
    private static final StringProperty OPERAND_DESCRIPTOR = new StringProperty("operand", "or/and value to refined match criteria", new String(), 2.0f);
    private static final StringMultiProperty TYPE_MATCH_DESCRIPTOR = new StringMultiProperty("typeMatch", "A series of regex, separated by ',' to match on implements/extends classname", new String[]{""}, 3.0f, ',');
    private static final StringProperty THRESHOLD_DESCRIPTOR = new StringProperty("threshold", "Defines how many occurrences are legal", new String(), 4.0f);
    private List<Pattern> namesMatch = new ArrayList<Pattern>(0);
    private List<Pattern> typesMatch = new ArrayList<Pattern>(0);
    private List<Node> matches = new ArrayList<Node>(0);
    private List<String> simpleClassname = new ArrayList<String>(0);
    private String operand;
    private int threshold;
    private static String counterLabel;

    public GenericClassCounterRule() {
        this.definePropertyDescriptor((PropertyDescriptor)NAME_MATCH_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)OPERAND_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)TYPE_MATCH_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)THRESHOLD_DESCRIPTOR);
    }

    protected void init() {
        counterLabel = this.getClass().getSimpleName() + ".number of match";
        this.namesMatch = RegexHelper.compilePatternsFromList((List)this.getProperty((PropertyDescriptor)NAME_MATCH_DESCRIPTOR));
        this.operand = (String)this.getProperty((PropertyDescriptor)OPERAND_DESCRIPTOR);
        this.typesMatch = RegexHelper.compilePatternsFromList((List)this.getProperty((PropertyDescriptor)TYPE_MATCH_DESCRIPTOR));
        String thresholdAsString = (String)this.getProperty((PropertyDescriptor)THRESHOLD_DESCRIPTOR);
        this.threshold = Integer.parseInt(thresholdAsString);
        this.matches = new ArrayList<Node>();
    }

    public void start(RuleContext ctx) {
        ctx.setAttribute(counterLabel, (Object)new AtomicLong());
        super.start(ctx);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        for (Pattern pattern : this.typesMatch) {
            if (!RegexHelper.isMatch(pattern, node.getImportedName())) continue;
            if (this.simpleClassname == null) {
                this.simpleClassname = new ArrayList<String>(1);
            }
            this.simpleClassname.add(node.getImportedName());
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceType classType, Object data) {
        for (String matchType : this.simpleClassname) {
            if (!this.searchForAMatch(matchType, (Node)classType)) continue;
            this.addAMatch((Node)classType, data);
        }
        for (Pattern pattern : this.namesMatch) {
            if (!RegexHelper.isMatch(pattern, classType.getImage())) continue;
            this.addAMatch((Node)classType, data);
        }
        return super.visit(classType, data);
    }

    private void addAMatch(Node node, Object data) {
        RuleContext ctx = (RuleContext)data;
        AtomicLong total = (AtomicLong)ctx.getAttribute(counterLabel);
        total.incrementAndGet();
        this.matches.add(node);
    }

    private boolean searchForAMatch(String matchType, Node node) {
        String xpathQuery = "//ClassOrInterfaceDeclaration[(./ExtendsList/ClassOrInterfaceType[@Image = '" + matchType + "']) or (./ImplementsList/ClassOrInterfaceType[@Image = '" + matchType + "'])]";
        return node.hasDescendantMatchingXPath(xpathQuery);
    }

    public void end(RuleContext ctx) {
        AtomicLong total = (AtomicLong)ctx.getAttribute(counterLabel);
        if (total.get() > (long)this.threshold) {
            for (Node node : this.matches) {
                this.addViolation(ctx, node, new Object[]{total});
            }
            ctx.removeAttribute(counterLabel);
            super.end(ctx);
        }
    }
}

