/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.java.typeresolution.PMDASMClassLoader;
import net.sourceforge.pmd.util.ClasspathClassLoader;

@Deprecated
@InternalApi
public class TypeSet {
    private final PMDASMClassLoader pmdClassLoader;
    private boolean hasAuxclasspath;
    private String pkg;
    private Set<String> imports = new HashSet<String>();
    private List<Resolver> resolvers = new ArrayList<Resolver>();

    public TypeSet() {
        this(TypeSet.class.getClassLoader());
    }

    public TypeSet(ClassLoader classLoader) {
        ClassLoader cl = classLoader;
        if (cl == null) {
            cl = TypeSet.class.getClassLoader();
        }
        this.hasAuxclasspath = cl instanceof ClasspathClassLoader;
        this.pmdClassLoader = PMDASMClassLoader.getInstance(cl);
    }

    public boolean hasAuxclasspath() {
        return this.hasAuxclasspath;
    }

    public void setASTCompilationUnitPackage(String pkg) {
        this.pkg = pkg;
    }

    public String getASTCompilationUnitPackage() {
        return this.pkg;
    }

    public void addImport(String importString) {
        this.imports.add(importString);
    }

    public int getImportsCount() {
        return this.imports.size();
    }

    public Set<String> getExplicitImports() {
        return this.imports;
    }

    public Class<?> findClass(String name) {
        if (this.resolvers.isEmpty()) {
            this.buildResolvers();
        }
        for (Resolver resolver : this.resolvers) {
            if (!resolver.couldResolve(name)) continue;
            try {
                return resolver.resolve(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (LinkageError le) {
                return null;
            }
        }
        return null;
    }

    private void buildResolvers() {
        this.resolvers.add(new PrimitiveTypeResolver());
        this.resolvers.add(new VoidResolver());
        this.resolvers.add(new ExplicitImportResolver(this.pmdClassLoader, this.imports));
        this.resolvers.add(new CurrentPackageResolver(this.pmdClassLoader, this.pkg));
        this.resolvers.add(new ImplicitImportResolver(this.pmdClassLoader));
        this.resolvers.add(new ImportOnDemandResolver(this.pmdClassLoader, this.imports));
        this.resolvers.add(new FullyQualifiedNameResolver(this.pmdClassLoader));
    }

    public static class FullyQualifiedNameResolver
    extends AbstractResolver {
        public FullyQualifiedNameResolver(PMDASMClassLoader pmdClassLoader) {
            super(pmdClassLoader);
        }

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            if (name == null) {
                throw new ClassNotFoundException();
            }
            Class<?> c = this.resolveMaybeInner(name, name);
            if (c == null) {
                throw new ClassNotFoundException("Type " + name + " not found");
            }
            return c;
        }

        @Override
        public boolean couldResolve(String name) {
            return true;
        }
    }

    public static class VoidResolver
    implements Resolver {
        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            if ("void".equals(name)) {
                return Void.TYPE;
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        public boolean couldResolve(String name) {
            return "void".equals(name);
        }
    }

    public static class PrimitiveTypeResolver
    implements Resolver {
        private static final Map<String, Class<?>> PRIMITIVE_TYPES;

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            if (!PRIMITIVE_TYPES.containsKey(name)) {
                throw new ClassNotFoundException(name);
            }
            return PRIMITIVE_TYPES.get(name);
        }

        @Override
        public boolean couldResolve(String name) {
            return PRIMITIVE_TYPES.containsKey(name);
        }

        static {
            HashMap<String, Class<Serializable>> types = new HashMap<String, Class<Serializable>>();
            types.put("int", Integer.TYPE);
            types.put("float", Float.TYPE);
            types.put("double", Double.TYPE);
            types.put("long", Long.TYPE);
            types.put("boolean", Boolean.TYPE);
            types.put("byte", Byte.TYPE);
            Class<Short> shortType = Short.TYPE;
            types.put("short", shortType);
            types.put("char", Character.TYPE);
            PRIMITIVE_TYPES = Collections.unmodifiableMap(types);
        }
    }

    public static class ImportOnDemandResolver
    extends AbstractResolver {
        private Set<String> importStmts = new HashSet<String>();

        public ImportOnDemandResolver(PMDASMClassLoader pmdClassLoader, Set<String> importStmts) {
            super(pmdClassLoader);
            for (String stmt : importStmts) {
                if (!stmt.endsWith("*")) continue;
                this.importStmts.add(stmt);
            }
        }

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            if (name == null) {
                throw new ClassNotFoundException();
            }
            name = name.replace('.', '$');
            for (String importStmt : this.importStmts) {
                String fqClassName = new StringBuilder(importStmt.length() + name.length()).append(importStmt).replace(importStmt.length() - 1, importStmt.length(), name).toString();
                if (!this.pmdClassLoader.couldResolve(fqClassName)) continue;
                try {
                    return this.pmdClassLoader.loadClass(fqClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException("Type " + name + " not found");
        }

        @Override
        public boolean couldResolve(String name) {
            name = name.replace('.', '$');
            for (String importStmt : this.importStmts) {
                String fqClassName = new StringBuilder(importStmt.length() + name.length()).append(importStmt).replace(importStmt.length() - 1, importStmt.length(), name).toString();
                if (!this.pmdClassLoader.couldResolve(fqClassName)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ImplicitImportResolver
    extends AbstractResolver {
        private static final ConcurrentHashMap<String, Class<?>> CLASS_CACHE = new ConcurrentHashMap();

        public ImplicitImportResolver(PMDASMClassLoader pmdClassLoader) {
            super(pmdClassLoader);
        }

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            if (name == null) {
                throw new ClassNotFoundException();
            }
            Class<?> clazz = CLASS_CACHE.get(name);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.pmdClassLoader.loadClass("java.lang.".concat(name.replace('.', '$')));
            CLASS_CACHE.putIfAbsent(name, clazz);
            return clazz;
        }

        @Override
        public boolean couldResolve(String name) {
            return this.pmdClassLoader.couldResolve("java.lang.".concat(name.replace('.', '$')));
        }
    }

    public static class CurrentPackageResolver
    extends AbstractResolver {
        private final String pkg;

        public CurrentPackageResolver(PMDASMClassLoader pmdClassLoader, String pkg) {
            super(pmdClassLoader);
            this.pkg = pkg == null || pkg.length() == 0 ? null : pkg + ".";
        }

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            if (name == null) {
                throw new ClassNotFoundException();
            }
            return this.pmdClassLoader.loadClass(this.qualifyName(name));
        }

        @Override
        public boolean couldResolve(String name) {
            return this.pmdClassLoader.couldResolve(this.qualifyName(name));
        }

        private String qualifyName(String name) {
            String qualifiedName = name.replace('.', '$');
            if (this.pkg == null) {
                return qualifiedName;
            }
            return this.pkg.concat(qualifiedName);
        }
    }

    public static class ExplicitImportResolver
    extends AbstractResolver {
        private Map<String, String> importStmts = new HashMap<String, String>();

        public ExplicitImportResolver(PMDASMClassLoader pmdClassLoader, Set<String> importStmts) {
            super(pmdClassLoader);
            for (String stmt : importStmts) {
                if (stmt.endsWith("*")) continue;
                this.importStmts.put(stmt, stmt);
                int lastDotIdx = stmt.lastIndexOf(46);
                if (lastDotIdx == -1) continue;
                this.importStmts.put(stmt.substring(lastDotIdx + 1), stmt);
            }
        }

        @Override
        public Class<?> resolve(String name) throws ClassNotFoundException {
            Class<?> c = this.resolveMaybeInner(name, this.importStmts.get(name));
            if (c == null) {
                throw new ClassNotFoundException("Type " + name + " not found");
            }
            return c;
        }

        @Override
        public boolean couldResolve(String name) {
            return this.importStmts.containsKey(name);
        }
    }

    public static abstract class AbstractResolver
    implements Resolver {
        protected final PMDASMClassLoader pmdClassLoader;
        private final Map<String, String> classNames;

        public AbstractResolver(PMDASMClassLoader pmdClassLoader) {
            this.pmdClassLoader = pmdClassLoader;
            this.classNames = new HashMap<String, String>();
        }

        protected Class<?> resolveMaybeInner(String name, String fqName) {
            String className = this.classNames.get(name);
            if (className != null) {
                try {
                    return this.pmdClassLoader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (fqName != null) {
                StringBuilder sb = new StringBuilder(fqName);
                String actualClassName = fqName;
                while (true) {
                    int lastDot;
                    if (this.pmdClassLoader.couldResolve(actualClassName)) {
                        try {
                            Class<?> c = this.pmdClassLoader.loadClass(actualClassName);
                            this.classNames.put(name, actualClassName);
                            return c;
                        }
                        catch (ClassNotFoundException c) {
                            // empty catch block
                        }
                    }
                    if ((lastDot = actualClassName.lastIndexOf(46)) == -1) break;
                    sb.setCharAt(lastDot, '$');
                    actualClassName = sb.toString();
                }
            }
            return null;
        }

        @Override
        public boolean couldResolve(String name) {
            return this.classNames.containsKey(name) || this.pmdClassLoader.couldResolve(name);
        }
    }

    public static interface Resolver {
        public Class<?> resolve(String var1) throws ClassNotFoundException;

        public boolean couldResolve(String var1);
    }
}

