/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.activiti.dmn.converter.child.BaseChildElementParser;
import org.activiti.dmn.model.DecisionTable;
import org.activiti.dmn.model.DmnElement;
import org.activiti.dmn.model.InputClause;
import org.activiti.dmn.model.LiteralExpression;

public class InputExpressionParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "inputExpression";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, DmnElement parentElement, DecisionTable decisionTable) throws Exception {
        if (!(parentElement instanceof InputClause)) {
            return;
        }
        InputClause clause = (InputClause)parentElement;
        LiteralExpression inputExpression = new LiteralExpression();
        inputExpression.setId(xtr.getAttributeValue(null, "id"));
        inputExpression.setTypeRef(xtr.getAttributeValue(null, "typeRef"));
        boolean readyWithInputExpression = false;
        try {
            while (!readyWithInputExpression && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "text".equalsIgnoreCase(xtr.getLocalName())) {
                    inputExpression.setText(xtr.getElementText());
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithInputExpression = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing input expression", (Throwable)e);
        }
        clause.setInputExpression(inputExpression);
    }
}

