/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Date;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.Activiti5Util;

public class SetTaskDueDateCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected Date dueDate;

    public SetTaskDueDateCmd(String taskId, Date dueDate) {
        super(taskId);
        this.dueDate = dueDate;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            activiti5CompatibilityHandler.setTaskDueDate(this.taskId, this.dueDate);
            return null;
        }
        task.setDueDate(this.dueDate);
        commandContext.getHistoryManager().recordTaskDueDateChange(task.getId(), task.getDueDate());
        commandContext.getTaskEntityManager().update(task);
        return null;
    }
}

