/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.DataObjectImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.runtime.DataObject;
import org.activiti.engine.task.Task;

public class GetTaskDataObjectCmd
implements Command<DataObject>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String variableName;
    protected String locale;
    protected boolean withLocalizationFallback;

    public GetTaskDataObjectCmd(String taskId, String variableName) {
        this.taskId = taskId;
        this.variableName = variableName;
    }

    public GetTaskDataObjectCmd(String taskId, String variableName, String locale, boolean withLocalizationFallback) {
        this.taskId = taskId;
        this.variableName = variableName;
        this.locale = locale;
        this.withLocalizationFallback = withLocalizationFallback;
    }

    @Override
    public DataObject execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ActivitiIllegalArgumentException("taskId is null");
        }
        if (this.variableName == null) {
            throw new ActivitiIllegalArgumentException("variableName is null");
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (task == null) {
            throw new ActivitiObjectNotFoundException("task " + this.taskId + " doesn't exist", Task.class);
        }
        DataObjectImpl dataObject = null;
        VariableInstance variableEntity = task.getVariableInstance(this.variableName, false);
        String localizedName = null;
        String localizedDescription = null;
        if (variableEntity != null) {
            ObjectNode languageNode;
            ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(variableEntity.getExecutionId());
            while (!executionEntity.isScope()) {
                executionEntity = executionEntity.getParent();
            }
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(executionEntity.getProcessDefinitionId());
            ValuedDataObject foundDataObject = null;
            if (executionEntity.getParentId() == null) {
                for (ValuedDataObject dataObjectDefinition : bpmnModel.getMainProcess().getDataObjects()) {
                    if (!dataObjectDefinition.getName().equals(variableEntity.getName())) continue;
                    foundDataObject = dataObjectDefinition;
                    break;
                }
            } else {
                SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(executionEntity.getActivityId());
                for (ValuedDataObject dataObjectDefinition : subProcess.getDataObjects()) {
                    if (!dataObjectDefinition.getName().equals(variableEntity.getName())) continue;
                    foundDataObject = dataObjectDefinition;
                    break;
                }
            }
            if (this.locale != null && foundDataObject != null && (languageNode = Context.getLocalizationElementProperties(this.locale, foundDataObject.getId(), task.getProcessDefinitionId(), this.withLocalizationFallback)) != null) {
                JsonNode descriptionNode;
                JsonNode nameNode = languageNode.get("name");
                if (nameNode != null) {
                    localizedName = nameNode.asText();
                }
                if ((descriptionNode = languageNode.get("description")) != null) {
                    localizedDescription = descriptionNode.asText();
                }
            }
            if (foundDataObject != null) {
                dataObject = new DataObjectImpl(variableEntity.getName(), variableEntity.getValue(), foundDataObject.getDocumentation(), foundDataObject.getType(), localizedName, localizedDescription, foundDataObject.getId());
            }
        }
        return dataObject;
    }
}

