/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CancelEventDefinition;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.Transaction;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class BoundaryEventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class);
        HashMap<String, Integer> cancelBoundaryEventsCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> compensateBoundaryEventsCounts = new HashMap<String, Integer>();
        for (int i = 0; i < boundaryEvents.size(); ++i) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)boundaryEvents.get(i);
            if (boundaryEvent.getEventDefinitions() != null && !boundaryEvent.getEventDefinitions().isEmpty()) {
                EventDefinition eventDefinition = (EventDefinition)boundaryEvent.getEventDefinitions().get(0);
                if (!(eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof ErrorEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof CancelEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof CompensateEventDefinition)) {
                    this.addError(errors, "activiti-boundary-event-invalid-event-definition", process, (BaseElement)boundaryEvent, "Invalid or unsupported event definition");
                }
                if (eventDefinition instanceof CancelEventDefinition) {
                    FlowElement attachedToFlowElement = bpmnModel.getFlowElement(boundaryEvent.getAttachedToRefId());
                    if (!(attachedToFlowElement instanceof Transaction)) {
                        this.addError(errors, "activiti-boundary-event-cancel-only-on-transaction", process, (BaseElement)boundaryEvent, "boundary event with cancelEventDefinition only supported on transaction subprocesses");
                        continue;
                    }
                    if (!cancelBoundaryEventsCounts.containsKey(attachedToFlowElement.getId())) {
                        cancelBoundaryEventsCounts.put(attachedToFlowElement.getId(), new Integer(0));
                    }
                    cancelBoundaryEventsCounts.put(attachedToFlowElement.getId(), new Integer((Integer)cancelBoundaryEventsCounts.get(attachedToFlowElement.getId()) + 1));
                    continue;
                }
                if (eventDefinition instanceof CompensateEventDefinition) {
                    if (!compensateBoundaryEventsCounts.containsKey(boundaryEvent.getAttachedToRefId())) {
                        compensateBoundaryEventsCounts.put(boundaryEvent.getAttachedToRefId(), new Integer(0));
                    }
                    compensateBoundaryEventsCounts.put(boundaryEvent.getAttachedToRefId(), (Integer)compensateBoundaryEventsCounts.get(boundaryEvent.getAttachedToRefId()) + 1);
                    continue;
                }
                if (!(eventDefinition instanceof MessageEventDefinition)) continue;
                for (int j = 0; j < boundaryEvents.size(); ++j) {
                    EventDefinition otherEventDefinition;
                    BoundaryEvent otherBoundaryEvent;
                    if (j == i || (otherBoundaryEvent = (BoundaryEvent)boundaryEvents.get(j)).getAttachedToRefId() == null || !otherBoundaryEvent.getAttachedToRefId().equals(boundaryEvent.getAttachedToRefId()) || otherBoundaryEvent.getEventDefinitions() == null || otherBoundaryEvent.getEventDefinitions().isEmpty() || !((otherEventDefinition = (EventDefinition)otherBoundaryEvent.getEventDefinitions().get(0)) instanceof MessageEventDefinition)) continue;
                    MessageEventDefinition currentMessageEventDefinition = (MessageEventDefinition)eventDefinition;
                    MessageEventDefinition otherMessageEventDefinition = (MessageEventDefinition)otherEventDefinition;
                    if (otherMessageEventDefinition.getMessageRef() == null || !otherMessageEventDefinition.getMessageRef().equals(currentMessageEventDefinition.getMessageRef())) continue;
                    this.addError(errors, "activiti-message-event-multiple-on-boundary-same-message-id", process, (BaseElement)boundaryEvent, "Multiple message events with same message id not supported");
                }
                continue;
            }
            this.addError(errors, "activiti-boundary-event-no-event-definition", process, (BaseElement)boundaryEvent, "Event definition is missing from boundary event");
        }
        for (String elementId : cancelBoundaryEventsCounts.keySet()) {
            if ((Integer)cancelBoundaryEventsCounts.get(elementId) <= 1) continue;
            this.addError(errors, "activiti-boundary-event-multiple-cancel-on-transaction", process, (BaseElement)bpmnModel.getFlowElement(elementId), "multiple boundary events with cancelEventDefinition not supported on same transaction subprocess.");
        }
        for (String elementId : compensateBoundaryEventsCounts.keySet()) {
            if ((Integer)compensateBoundaryEventsCounts.get(elementId) <= 1) continue;
            this.addError(errors, "activiti-compensate-event-multiple-on-boundary", process, (BaseElement)bpmnModel.getFlowElement(elementId), "Multiple boundary events of type 'compensate' is invalid");
        }
    }
}

