/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.boot.process.validation;

import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class AsyncPropertyValidator
extends ProcessLevelValidator {
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        this.validateFlowElementsInContainer((FlowElementsContainer)process, errors, process);
    }

    protected void validateFlowElementsInContainer(FlowElementsContainer container, List<ValidationError> errors, Process process) {
        for (FlowElement flowElement : container.getFlowElements()) {
            if (flowElement instanceof FlowElementsContainer) {
                FlowElementsContainer subProcess = (FlowElementsContainer)flowElement;
                this.validateFlowElementsInContainer(subProcess, errors, process);
            }
            if (flowElement instanceof FlowNode && ((FlowNode)flowElement).isAsynchronous()) {
                this.addWarning(errors, "activiti-flow-element-async-not-available", process, (BaseElement)flowElement, "Async property is not available when asyncExecutor is disabled.");
            }
            if (!(flowElement instanceof Event)) continue;
            ((Event)flowElement).getEventDefinitions().stream().forEach(event -> {
                if (event instanceof TimerEventDefinition) {
                    this.addWarning(errors, "activiti-event-timer-async-not-available", process, (BaseElement)flowElement, "Timer event is not available when asyncExecutor is disabled.");
                } else if (event instanceof SignalEventDefinition && ((SignalEventDefinition)event).isAsync()) {
                    this.addWarning(errors, "activiti-signal-async-not-available", process, (BaseElement)flowElement, "Async property is not available when asyncExecutor is disabled.");
                }
            });
        }
    }
}

