/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.autodeployment;

import java.io.IOException;
import java.util.List;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.core.common.spring.project.ProjectModelService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.util.io.InputStreamSource;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.spring.autodeployment.AutoDeploymentStrategy;
import org.activiti.validation.ValidationError;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;

public abstract class AbstractAutoDeploymentStrategy
implements AutoDeploymentStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractAutoDeploymentStrategy.class);
    private ProjectModelService projectModelService;

    public AbstractAutoDeploymentStrategy(ProjectModelService projectModelService) {
        this.projectModelService = projectModelService;
    }

    protected abstract String getDeploymentMode();

    @Override
    public boolean handlesMode(String mode) {
        return StringUtils.equalsIgnoreCase((CharSequence)mode, (CharSequence)this.getDeploymentMode());
    }

    protected String determineResourceName(Resource resource) {
        String resourceName;
        if (resource instanceof ContextResource) {
            resourceName = ((ContextResource)resource).getPathWithinContext();
        } else if (resource instanceof ByteArrayResource) {
            resourceName = resource.getDescription();
        } else {
            try {
                resourceName = resource.getFile().getAbsolutePath();
            }
            catch (IOException e) {
                resourceName = resource.getFilename();
            }
        }
        return resourceName;
    }

    protected boolean validateModel(Resource resource, RepositoryService repositoryService) {
        String resourceName = this.determineResourceName(resource);
        if (this.isProcessDefinitionResource(resourceName)) {
            try {
                BpmnXMLConverter converter = new BpmnXMLConverter();
                BpmnModel bpmnModel = converter.convertToBpmnModel((InputStreamProvider)new InputStreamSource(resource.getInputStream()), true, false);
                List validationErrors = repositoryService.validateProcess(bpmnModel);
                if (validationErrors != null && !validationErrors.isEmpty()) {
                    StringBuilder warningBuilder = new StringBuilder();
                    StringBuilder errorBuilder = new StringBuilder();
                    for (ValidationError error : validationErrors) {
                        if (error.isWarning()) {
                            warningBuilder.append(error.toString());
                            warningBuilder.append("\n");
                        } else {
                            errorBuilder.append(error.toString());
                            errorBuilder.append("\n");
                        }
                        if (warningBuilder.length() > 0) {
                            LOGGER.warn("Following warnings encountered during process validation: " + warningBuilder.toString());
                        }
                        if (errorBuilder.length() <= 0) continue;
                        LOGGER.error("Errors while parsing:\n" + errorBuilder.toString());
                        return false;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error parsing XML", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean isProcessDefinitionResource(String resource) {
        return resource.endsWith(".bpmn20.xml") || resource.endsWith(".bpmn");
    }

    protected DeploymentBuilder loadProjectManifest(DeploymentBuilder deploymentBuilder) {
        if (this.projectModelService != null && this.projectModelService.hasProjectManifest()) {
            try {
                deploymentBuilder.setProjectManifest(this.projectModelService.loadProjectManifest());
            }
            catch (IOException e) {
                LOGGER.warn("Manifest of application not found. Project release version will not be set for deployment.");
            }
        }
        return deploymentBuilder;
    }
}

